// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsConfiguration;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsProvisioningState;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsProvisioningSubstate;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.frontdoor.models.SessionAffinityEnabledState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A frontend endpoint used for routing. */
@Fluent
public final class FrontendEndpointInner extends SubResource {
    /*
     * Properties of the Frontend endpoint
     */
    @JsonProperty(value = "properties")
    private FrontendEndpointProperties innerProperties;

    /*
     * Resource name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /** Creates an instance of FrontendEndpointInner class. */
    public FrontendEndpointInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Frontend endpoint.
     *
     * @return the innerProperties value.
     */
    private FrontendEndpointProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Resource name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Resource name.
     *
     * @param name the name value to set.
     * @return the FrontendEndpointInner object itself.
     */
    public FrontendEndpointInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Resource type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public FrontendEndpointInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the resourceState property: Resource status of the Front Door or Front Door SubResource.
     *
     * <p>Resource status.
     *
     * @return the resourceState value.
     */
    public FrontDoorResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    /**
     * Get the customHttpsProvisioningState property: Provisioning status of Custom Https of the frontendEndpoint.
     *
     * @return the customHttpsProvisioningState value.
     */
    public CustomHttpsProvisioningState customHttpsProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().customHttpsProvisioningState();
    }

    /**
     * Get the customHttpsProvisioningSubstate property: Provisioning substate shows the progress of custom HTTPS
     * enabling/disabling process step by step.
     *
     * @return the customHttpsProvisioningSubstate value.
     */
    public CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate() {
        return this.innerProperties() == null ? null : this.innerProperties().customHttpsProvisioningSubstate();
    }

    /**
     * Get the customHttpsConfiguration property: The configuration specifying how to enable HTTPS.
     *
     * @return the customHttpsConfiguration value.
     */
    public CustomHttpsConfiguration customHttpsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().customHttpsConfiguration();
    }

    /**
     * Get the hostname property: The host name of the frontendEndpoint. Must be a domain name.
     *
     * @return the hostname value.
     */
    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    /**
     * Set the hostname property: The host name of the frontendEndpoint. Must be a domain name.
     *
     * @param hostname the hostname value to set.
     * @return the FrontendEndpointInner object itself.
     */
    public FrontendEndpointInner withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendEndpointProperties();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    /**
     * Get the sessionAffinityEnabledState property: Whether to allow session affinity on this host. Valid options are
     * 'Enabled' or 'Disabled'.
     *
     * @return the sessionAffinityEnabledState value.
     */
    public SessionAffinityEnabledState sessionAffinityEnabledState() {
        return this.innerProperties() == null ? null : this.innerProperties().sessionAffinityEnabledState();
    }

    /**
     * Set the sessionAffinityEnabledState property: Whether to allow session affinity on this host. Valid options are
     * 'Enabled' or 'Disabled'.
     *
     * @param sessionAffinityEnabledState the sessionAffinityEnabledState value to set.
     * @return the FrontendEndpointInner object itself.
     */
    public FrontendEndpointInner withSessionAffinityEnabledState(
        SessionAffinityEnabledState sessionAffinityEnabledState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendEndpointProperties();
        }
        this.innerProperties().withSessionAffinityEnabledState(sessionAffinityEnabledState);
        return this;
    }

    /**
     * Get the sessionAffinityTtlSeconds property: UNUSED. This field will be ignored. The TTL to use in seconds for
     * session affinity, if applicable.
     *
     * @return the sessionAffinityTtlSeconds value.
     */
    public Integer sessionAffinityTtlSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().sessionAffinityTtlSeconds();
    }

    /**
     * Set the sessionAffinityTtlSeconds property: UNUSED. This field will be ignored. The TTL to use in seconds for
     * session affinity, if applicable.
     *
     * @param sessionAffinityTtlSeconds the sessionAffinityTtlSeconds value to set.
     * @return the FrontendEndpointInner object itself.
     */
    public FrontendEndpointInner withSessionAffinityTtlSeconds(Integer sessionAffinityTtlSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendEndpointProperties();
        }
        this.innerProperties().withSessionAffinityTtlSeconds(sessionAffinityTtlSeconds);
        return this;
    }

    /**
     * Get the webApplicationFirewallPolicyLink property: Defines the Web Application Firewall policy for each host (if
     * applicable).
     *
     * @return the webApplicationFirewallPolicyLink value.
     */
    public FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.innerProperties() == null ? null : this.innerProperties().webApplicationFirewallPolicyLink();
    }

    /**
     * Set the webApplicationFirewallPolicyLink property: Defines the Web Application Firewall policy for each host (if
     * applicable).
     *
     * @param webApplicationFirewallPolicyLink the webApplicationFirewallPolicyLink value to set.
     * @return the FrontendEndpointInner object itself.
     */
    public FrontendEndpointInner withWebApplicationFirewallPolicyLink(
        FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FrontendEndpointProperties();
        }
        this.innerProperties().withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
