// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsConfiguration;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsProvisioningState;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsProvisioningSubstate;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointUpdateParameters;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.frontdoor.models.SessionAffinityEnabledState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The JSON object that contains the properties required to create a frontend endpoint. */
@Fluent
public final class FrontendEndpointProperties extends FrontendEndpointUpdateParameters {
    /*
     * Resource status of the Front Door or Front Door SubResource.
     *
     * Resource status.
     */
    @JsonProperty(value = "resourceState", access = JsonProperty.Access.WRITE_ONLY)
    private FrontDoorResourceState resourceState;

    /*
     * Provisioning status of Custom Https of the frontendEndpoint.
     */
    @JsonProperty(value = "customHttpsProvisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private CustomHttpsProvisioningState customHttpsProvisioningState;

    /*
     * Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
     */
    @JsonProperty(value = "customHttpsProvisioningSubstate", access = JsonProperty.Access.WRITE_ONLY)
    private CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate;

    /*
     * The configuration specifying how to enable HTTPS
     */
    @JsonProperty(value = "customHttpsConfiguration", access = JsonProperty.Access.WRITE_ONLY)
    private CustomHttpsConfiguration customHttpsConfiguration;

    /** Creates an instance of FrontendEndpointProperties class. */
    public FrontendEndpointProperties() {
    }

    /**
     * Get the resourceState property: Resource status of the Front Door or Front Door SubResource.
     *
     * <p>Resource status.
     *
     * @return the resourceState value.
     */
    public FrontDoorResourceState resourceState() {
        return this.resourceState;
    }

    /**
     * Get the customHttpsProvisioningState property: Provisioning status of Custom Https of the frontendEndpoint.
     *
     * @return the customHttpsProvisioningState value.
     */
    public CustomHttpsProvisioningState customHttpsProvisioningState() {
        return this.customHttpsProvisioningState;
    }

    /**
     * Get the customHttpsProvisioningSubstate property: Provisioning substate shows the progress of custom HTTPS
     * enabling/disabling process step by step.
     *
     * @return the customHttpsProvisioningSubstate value.
     */
    public CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate() {
        return this.customHttpsProvisioningSubstate;
    }

    /**
     * Get the customHttpsConfiguration property: The configuration specifying how to enable HTTPS.
     *
     * @return the customHttpsConfiguration value.
     */
    public CustomHttpsConfiguration customHttpsConfiguration() {
        return this.customHttpsConfiguration;
    }

    /** {@inheritDoc} */
    @Override
    public FrontendEndpointProperties withHostname(String hostname) {
        super.withHostname(hostname);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public FrontendEndpointProperties withSessionAffinityEnabledState(
        SessionAffinityEnabledState sessionAffinityEnabledState) {
        super.withSessionAffinityEnabledState(sessionAffinityEnabledState);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public FrontendEndpointProperties withSessionAffinityTtlSeconds(Integer sessionAffinityTtlSeconds) {
        super.withSessionAffinityTtlSeconds(sessionAffinityTtlSeconds);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public FrontendEndpointProperties withWebApplicationFirewallPolicyLink(
        FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        super.withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (customHttpsConfiguration() != null) {
            customHttpsConfiguration().validate();
        }
    }
}
