// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.frontdoor.models.LatencyMetric;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/** Defines the LatencyScorecard. */
@Fluent
public final class LatencyScorecardInner extends Resource {
    /*
     * The properties of a latency scorecard
     */
    @JsonProperty(value = "properties")
    private LatencyScorecardProperties innerProperties;

    /** Creates an instance of LatencyScorecardInner class. */
    public LatencyScorecardInner() {
    }

    /**
     * Get the innerProperties property: The properties of a latency scorecard.
     *
     * @return the innerProperties value.
     */
    private LatencyScorecardProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public LatencyScorecardInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public LatencyScorecardInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the id property: The unique identifier of the Latency Scorecard.
     *
     * @return the id value.
     */
    public String idPropertiesId() {
        return this.innerProperties() == null ? null : this.innerProperties().id();
    }

    /**
     * Get the name property: The name of the Latency Scorecard.
     *
     * @return the name value.
     */
    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    /**
     * Get the description property: The description of the Latency Scorecard.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Get the endpointA property: The A endpoint in the scorecard.
     *
     * @return the endpointA value.
     */
    public String endpointA() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointA();
    }

    /**
     * Get the endpointB property: The B endpoint in the scorecard.
     *
     * @return the endpointB value.
     */
    public String endpointB() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointB();
    }

    /**
     * Get the startDateTimeUtc property: The start time of the Latency Scorecard in UTC.
     *
     * @return the startDateTimeUtc value.
     */
    public OffsetDateTime startDateTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().startDateTimeUtc();
    }

    /**
     * Get the endDateTimeUtc property: The end time of the Latency Scorecard in UTC.
     *
     * @return the endDateTimeUtc value.
     */
    public OffsetDateTime endDateTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().endDateTimeUtc();
    }

    /**
     * Get the country property: The country associated with the Latency Scorecard. Values are country ISO codes as
     * specified here- https://www.iso.org/iso-3166-country-codes.html.
     *
     * @return the country value.
     */
    public String country() {
        return this.innerProperties() == null ? null : this.innerProperties().country();
    }

    /**
     * Get the latencyMetrics property: The latency metrics of the Latency Scorecard.
     *
     * @return the latencyMetrics value.
     */
    public List<LatencyMetric> latencyMetrics() {
        return this.innerProperties() == null ? null : this.innerProperties().latencyMetrics();
    }

    /**
     * Set the latencyMetrics property: The latency metrics of the Latency Scorecard.
     *
     * @param latencyMetrics the latencyMetrics value to set.
     * @return the LatencyScorecardInner object itself.
     */
    public LatencyScorecardInner withLatencyMetrics(List<LatencyMetric> latencyMetrics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LatencyScorecardProperties();
        }
        this.innerProperties().withLatencyMetrics(latencyMetrics);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
