// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.frontdoor.models.LatencyMetric;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Defines a the properties of a Latency Scorecard. */
@Fluent
public final class LatencyScorecardProperties {
    /*
     * The unique identifier of the Latency Scorecard
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The name of the Latency Scorecard
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The description of the Latency Scorecard
     */
    @JsonProperty(value = "description", access = JsonProperty.Access.WRITE_ONLY)
    private String description;

    /*
     * The A endpoint in the scorecard
     */
    @JsonProperty(value = "endpointA", access = JsonProperty.Access.WRITE_ONLY)
    private String endpointA;

    /*
     * The B endpoint in the scorecard
     */
    @JsonProperty(value = "endpointB", access = JsonProperty.Access.WRITE_ONLY)
    private String endpointB;

    /*
     * The start time of the Latency Scorecard in UTC
     */
    @JsonProperty(value = "startDateTimeUTC", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startDateTimeUtc;

    /*
     * The end time of the Latency Scorecard in UTC
     */
    @JsonProperty(value = "endDateTimeUTC", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endDateTimeUtc;

    /*
     * The country associated with the Latency Scorecard. Values are country ISO codes as specified here-
     * https://www.iso.org/iso-3166-country-codes.html
     */
    @JsonProperty(value = "country", access = JsonProperty.Access.WRITE_ONLY)
    private String country;

    /*
     * The latency metrics of the Latency Scorecard
     */
    @JsonProperty(value = "latencyMetrics")
    private List<LatencyMetric> latencyMetrics;

    /** Creates an instance of LatencyScorecardProperties class. */
    public LatencyScorecardProperties() {
    }

    /**
     * Get the id property: The unique identifier of the Latency Scorecard.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the Latency Scorecard.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the description property: The description of the Latency Scorecard.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the endpointA property: The A endpoint in the scorecard.
     *
     * @return the endpointA value.
     */
    public String endpointA() {
        return this.endpointA;
    }

    /**
     * Get the endpointB property: The B endpoint in the scorecard.
     *
     * @return the endpointB value.
     */
    public String endpointB() {
        return this.endpointB;
    }

    /**
     * Get the startDateTimeUtc property: The start time of the Latency Scorecard in UTC.
     *
     * @return the startDateTimeUtc value.
     */
    public OffsetDateTime startDateTimeUtc() {
        return this.startDateTimeUtc;
    }

    /**
     * Get the endDateTimeUtc property: The end time of the Latency Scorecard in UTC.
     *
     * @return the endDateTimeUtc value.
     */
    public OffsetDateTime endDateTimeUtc() {
        return this.endDateTimeUtc;
    }

    /**
     * Get the country property: The country associated with the Latency Scorecard. Values are country ISO codes as
     * specified here- https://www.iso.org/iso-3166-country-codes.html.
     *
     * @return the country value.
     */
    public String country() {
        return this.country;
    }

    /**
     * Get the latencyMetrics property: The latency metrics of the Latency Scorecard.
     *
     * @return the latencyMetrics value.
     */
    public List<LatencyMetric> latencyMetrics() {
        return this.latencyMetrics;
    }

    /**
     * Set the latencyMetrics property: The latency metrics of the Latency Scorecard.
     *
     * @param latencyMetrics the latencyMetrics value to set.
     * @return the LatencyScorecardProperties object itself.
     */
    public LatencyScorecardProperties withLatencyMetrics(List<LatencyMetric> latencyMetrics) {
        this.latencyMetrics = latencyMetrics;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (latencyMetrics() != null) {
            latencyMetrics().forEach(e -> e.validate());
        }
    }
}
