// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleGroupDefinition;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** Describes the a managed rule set definition. */
@Fluent
public final class ManagedRuleSetDefinitionInner extends Resource {
    /*
     * Properties for a managed rule set definition.
     */
    @JsonProperty(value = "properties")
    private ManagedRuleSetDefinitionProperties innerProperties;

    /** Creates an instance of ManagedRuleSetDefinitionInner class. */
    public ManagedRuleSetDefinitionInner() {
    }

    /**
     * Get the innerProperties property: Properties for a managed rule set definition.
     *
     * @return the innerProperties value.
     */
    private ManagedRuleSetDefinitionProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedRuleSetDefinitionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedRuleSetDefinitionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the managed rule set.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the ruleSetId property: Id of the managed rule set.
     *
     * @return the ruleSetId value.
     */
    public String ruleSetId() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetId();
    }

    /**
     * Get the ruleSetType property: Type of the managed rule set.
     *
     * @return the ruleSetType value.
     */
    public String ruleSetType() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetType();
    }

    /**
     * Get the ruleSetVersion property: Version of the managed rule set type.
     *
     * @return the ruleSetVersion value.
     */
    public String ruleSetVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleSetVersion();
    }

    /**
     * Get the ruleGroups property: Rule groups of the managed rule set.
     *
     * @return the ruleGroups value.
     */
    public List<ManagedRuleGroupDefinition> ruleGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().ruleGroups();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
