// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.RulesEngineRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the request
 * and response.
 */
@Fluent
public final class RulesEngineInner extends ProxyResource {
    /*
     * Properties of the Rules Engine Configuration.
     */
    @JsonProperty(value = "properties")
    private RulesEngineProperties innerProperties;

    /** Creates an instance of RulesEngineInner class. */
    public RulesEngineInner() {
    }

    /**
     * Get the innerProperties property: Properties of the Rules Engine Configuration.
     *
     * @return the innerProperties value.
     */
    private RulesEngineProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the resourceState property: Resource status of the Front Door or Front Door SubResource.
     *
     * <p>Resource status.
     *
     * @return the resourceState value.
     */
    public FrontDoorResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    /**
     * Get the rules property: A list of rules that define a particular Rules Engine Configuration.
     *
     * @return the rules value.
     */
    public List<RulesEngineRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    /**
     * Set the rules property: A list of rules that define a particular Rules Engine Configuration.
     *
     * @param rules the rules value to set.
     * @return the RulesEngineInner object itself.
     */
    public RulesEngineInner withRules(List<RulesEngineRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RulesEngineProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
