// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.frontdoor.models.CustomRuleList;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointLink;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleSetList;
import com.azure.resourcemanager.frontdoor.models.PolicyResourceState;
import com.azure.resourcemanager.frontdoor.models.PolicySettings;
import com.azure.resourcemanager.frontdoor.models.RoutingRuleLink;
import com.azure.resourcemanager.frontdoor.models.SecurityPolicyLink;
import com.azure.resourcemanager.frontdoor.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** Defines web application firewall policy. */
@Fluent
public final class WebApplicationFirewallPolicyInner extends Resource {
    /*
     * Properties of the web application firewall policy.
     */
    @JsonProperty(value = "properties")
    private WebApplicationFirewallPolicyProperties innerProperties;

    /*
     * Gets a unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag")
    private String etag;

    /*
     * The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
     */
    @JsonProperty(value = "sku")
    private Sku sku;

    /** Creates an instance of WebApplicationFirewallPolicyInner class. */
    public WebApplicationFirewallPolicyInner() {
    }

    /**
     * Get the innerProperties property: Properties of the web application firewall policy.
     *
     * @return the innerProperties value.
     */
    private WebApplicationFirewallPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: Gets a unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: Gets a unique read-only string that changes whenever the resource is updated.
     *
     * @param etag the etag value to set.
     * @return the WebApplicationFirewallPolicyInner object itself.
     */
    public WebApplicationFirewallPolicyInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the sku property: The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if
     * not specified.
     *
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if
     * not specified.
     *
     * @param sku the sku value to set.
     * @return the WebApplicationFirewallPolicyInner object itself.
     */
    public WebApplicationFirewallPolicyInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public WebApplicationFirewallPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public WebApplicationFirewallPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the policySettings property: Describes settings for the policy.
     *
     * @return the policySettings value.
     */
    public PolicySettings policySettings() {
        return this.innerProperties() == null ? null : this.innerProperties().policySettings();
    }

    /**
     * Set the policySettings property: Describes settings for the policy.
     *
     * @param policySettings the policySettings value to set.
     * @return the WebApplicationFirewallPolicyInner object itself.
     */
    public WebApplicationFirewallPolicyInner withPolicySettings(PolicySettings policySettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withPolicySettings(policySettings);
        return this;
    }

    /**
     * Get the customRules property: Describes custom rules inside the policy.
     *
     * @return the customRules value.
     */
    public CustomRuleList customRules() {
        return this.innerProperties() == null ? null : this.innerProperties().customRules();
    }

    /**
     * Set the customRules property: Describes custom rules inside the policy.
     *
     * @param customRules the customRules value to set.
     * @return the WebApplicationFirewallPolicyInner object itself.
     */
    public WebApplicationFirewallPolicyInner withCustomRules(CustomRuleList customRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withCustomRules(customRules);
        return this;
    }

    /**
     * Get the managedRules property: Describes managed rules inside the policy.
     *
     * @return the managedRules value.
     */
    public ManagedRuleSetList managedRules() {
        return this.innerProperties() == null ? null : this.innerProperties().managedRules();
    }

    /**
     * Set the managedRules property: Describes managed rules inside the policy.
     *
     * @param managedRules the managedRules value to set.
     * @return the WebApplicationFirewallPolicyInner object itself.
     */
    public WebApplicationFirewallPolicyInner withManagedRules(ManagedRuleSetList managedRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withManagedRules(managedRules);
        return this;
    }

    /**
     * Get the frontendEndpointLinks property: Describes Frontend Endpoints associated with this Web Application
     * Firewall policy.
     *
     * @return the frontendEndpointLinks value.
     */
    public List<FrontendEndpointLink> frontendEndpointLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendEndpointLinks();
    }

    /**
     * Get the routingRuleLinks property: Describes Routing Rules associated with this Web Application Firewall policy.
     *
     * @return the routingRuleLinks value.
     */
    public List<RoutingRuleLink> routingRuleLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().routingRuleLinks();
    }

    /**
     * Get the securityPolicyLinks property: Describes Security Policy associated with this Web Application Firewall
     * policy.
     *
     * @return the securityPolicyLinks value.
     */
    public List<SecurityPolicyLink> securityPolicyLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().securityPolicyLinks();
    }

    /**
     * Get the provisioningState property: Provisioning state of the policy.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the resourceState property: Resource status of the policy.
     *
     * @return the resourceState value.
     */
    public PolicyResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
    }
}
