// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.fluent.EndpointsClient;
import com.azure.resourcemanager.frontdoor.models.Endpoints;
import com.azure.resourcemanager.frontdoor.models.PurgeParameters;

public final class EndpointsImpl implements Endpoints {
    private static final ClientLogger LOGGER = new ClientLogger(EndpointsImpl.class);

    private final EndpointsClient innerClient;

    private final com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager;

    public EndpointsImpl(
        EndpointsClient innerClient, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public void purgeContent(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths) {
        this.serviceClient().purgeContent(resourceGroupName, frontDoorName, contentFilePaths);
    }

    public void purgeContent(
        String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths, Context context) {
        this.serviceClient().purgeContent(resourceGroupName, frontDoorName, contentFilePaths, context);
    }

    private EndpointsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.frontdoor.FrontDoorManager manager() {
        return this.serviceManager;
    }
}
