// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.fluent.models.ExperimentInner;
import com.azure.resourcemanager.frontdoor.models.Endpoint;
import com.azure.resourcemanager.frontdoor.models.Experiment;
import com.azure.resourcemanager.frontdoor.models.ExperimentUpdateModel;
import com.azure.resourcemanager.frontdoor.models.NetworkExperimentResourceState;
import com.azure.resourcemanager.frontdoor.models.State;
import java.util.Collections;
import java.util.Map;

public final class ExperimentImpl implements Experiment, Experiment.Definition, Experiment.Update {
    private ExperimentInner innerObject;

    private final com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public String description() {
        return this.innerModel().description();
    }

    public Endpoint endpointA() {
        return this.innerModel().endpointA();
    }

    public Endpoint endpointB() {
        return this.innerModel().endpointB();
    }

    public State enabledState() {
        return this.innerModel().enabledState();
    }

    public NetworkExperimentResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    public String status() {
        return this.innerModel().status();
    }

    public String scriptFileUri() {
        return this.innerModel().scriptFileUri();
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ExperimentInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.frontdoor.FrontDoorManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String profileName;

    private String experimentName;

    private ExperimentUpdateModel updateParameters;

    public ExperimentImpl withExistingNetworkExperimentProfile(String resourceGroupName, String profileName) {
        this.resourceGroupName = resourceGroupName;
        this.profileName = profileName;
        return this;
    }

    public Experiment create() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getExperiments()
                .createOrUpdate(resourceGroupName, profileName, experimentName, this.innerModel(), Context.NONE);
        return this;
    }

    public Experiment create(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getExperiments()
                .createOrUpdate(resourceGroupName, profileName, experimentName, this.innerModel(), context);
        return this;
    }

    ExperimentImpl(String name, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = new ExperimentInner();
        this.serviceManager = serviceManager;
        this.experimentName = name;
    }

    public ExperimentImpl update() {
        this.updateParameters = new ExperimentUpdateModel();
        return this;
    }

    public Experiment apply() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getExperiments()
                .update(resourceGroupName, profileName, experimentName, updateParameters, Context.NONE);
        return this;
    }

    public Experiment apply(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getExperiments()
                .update(resourceGroupName, profileName, experimentName, updateParameters, context);
        return this;
    }

    ExperimentImpl(ExperimentInner innerObject, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.profileName = Utils.getValueFromIdByName(innerObject.id(), "NetworkExperimentProfiles");
        this.experimentName = Utils.getValueFromIdByName(innerObject.id(), "Experiments");
    }

    public Experiment refresh() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getExperiments()
                .getWithResponse(resourceGroupName, profileName, experimentName, Context.NONE)
                .getValue();
        return this;
    }

    public Experiment refresh(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getExperiments()
                .getWithResponse(resourceGroupName, profileName, experimentName, context)
                .getValue();
        return this;
    }

    public ExperimentImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public ExperimentImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public ExperimentImpl withTags(Map<String, String> tags) {
        if (isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        } else {
            this.updateParameters.withTags(tags);
            return this;
        }
    }

    public ExperimentImpl withDescription(String description) {
        if (isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        } else {
            this.updateParameters.withDescription(description);
            return this;
        }
    }

    public ExperimentImpl withEndpointA(Endpoint endpointA) {
        this.innerModel().withEndpointA(endpointA);
        return this;
    }

    public ExperimentImpl withEndpointB(Endpoint endpointB) {
        this.innerModel().withEndpointB(endpointB);
        return this;
    }

    public ExperimentImpl withEnabledState(State enabledState) {
        if (isInCreateMode()) {
            this.innerModel().withEnabledState(enabledState);
            return this;
        } else {
            this.updateParameters.withEnabledState(enabledState);
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
