// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontDoorInner;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontendEndpointInner;
import com.azure.resourcemanager.frontdoor.fluent.models.RulesEngineInner;
import com.azure.resourcemanager.frontdoor.models.BackendPool;
import com.azure.resourcemanager.frontdoor.models.BackendPoolsSettings;
import com.azure.resourcemanager.frontdoor.models.FrontDoor;
import com.azure.resourcemanager.frontdoor.models.FrontDoorEnabledState;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpoint;
import com.azure.resourcemanager.frontdoor.models.HealthProbeSettingsModel;
import com.azure.resourcemanager.frontdoor.models.LoadBalancingSettingsModel;
import com.azure.resourcemanager.frontdoor.models.RoutingRule;
import com.azure.resourcemanager.frontdoor.models.RulesEngine;
import com.azure.resourcemanager.frontdoor.models.ValidateCustomDomainInput;
import com.azure.resourcemanager.frontdoor.models.ValidateCustomDomainOutput;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class FrontDoorImpl implements FrontDoor, FrontDoor.Definition, FrontDoor.Update {
    private FrontDoorInner innerObject;

    private final com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public FrontDoorResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String cname() {
        return this.innerModel().cname();
    }

    public String frontdoorId() {
        return this.innerModel().frontdoorId();
    }

    public List<RulesEngine> rulesEngines() {
        List<RulesEngineInner> inner = this.innerModel().rulesEngines();
        if (inner != null) {
            return Collections
                .unmodifiableList(
                    inner
                        .stream()
                        .map(inner1 -> new RulesEngineImpl(inner1, this.manager()))
                        .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public Map<String, String> extendedProperties() {
        Map<String, String> inner = this.innerModel().extendedProperties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public String friendlyName() {
        return this.innerModel().friendlyName();
    }

    public List<RoutingRule> routingRules() {
        List<RoutingRule> inner = this.innerModel().routingRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<LoadBalancingSettingsModel> loadBalancingSettings() {
        List<LoadBalancingSettingsModel> inner = this.innerModel().loadBalancingSettings();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<HealthProbeSettingsModel> healthProbeSettings() {
        List<HealthProbeSettingsModel> inner = this.innerModel().healthProbeSettings();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<BackendPool> backendPools() {
        List<BackendPool> inner = this.innerModel().backendPools();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public List<FrontendEndpoint> frontendEndpoints() {
        List<FrontendEndpointInner> inner = this.innerModel().frontendEndpoints();
        if (inner != null) {
            return Collections
                .unmodifiableList(
                    inner
                        .stream()
                        .map(inner1 -> new FrontendEndpointImpl(inner1, this.manager()))
                        .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public BackendPoolsSettings backendPoolsSettings() {
        return this.innerModel().backendPoolsSettings();
    }

    public FrontDoorEnabledState enabledState() {
        return this.innerModel().enabledState();
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public FrontDoorInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.frontdoor.FrontDoorManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String frontDoorName;

    public FrontDoorImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public FrontDoor create() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getFrontDoors()
                .createOrUpdate(resourceGroupName, frontDoorName, this.innerModel(), Context.NONE);
        return this;
    }

    public FrontDoor create(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getFrontDoors()
                .createOrUpdate(resourceGroupName, frontDoorName, this.innerModel(), context);
        return this;
    }

    FrontDoorImpl(String name, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = new FrontDoorInner();
        this.serviceManager = serviceManager;
        this.frontDoorName = name;
    }

    public FrontDoorImpl update() {
        return this;
    }

    public FrontDoor apply() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getFrontDoors()
                .createOrUpdate(resourceGroupName, frontDoorName, this.innerModel(), Context.NONE);
        return this;
    }

    public FrontDoor apply(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getFrontDoors()
                .createOrUpdate(resourceGroupName, frontDoorName, this.innerModel(), context);
        return this;
    }

    FrontDoorImpl(FrontDoorInner innerObject, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.frontDoorName = Utils.getValueFromIdByName(innerObject.id(), "frontDoors");
    }

    public FrontDoor refresh() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getFrontDoors()
                .getByResourceGroupWithResponse(resourceGroupName, frontDoorName, Context.NONE)
                .getValue();
        return this;
    }

    public FrontDoor refresh(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getFrontDoors()
                .getByResourceGroupWithResponse(resourceGroupName, frontDoorName, context)
                .getValue();
        return this;
    }

    public Response<ValidateCustomDomainOutput> validateCustomDomainWithResponse(
        ValidateCustomDomainInput customDomainProperties, Context context) {
        return serviceManager
            .frontDoors()
            .validateCustomDomainWithResponse(resourceGroupName, frontDoorName, customDomainProperties, context);
    }

    public ValidateCustomDomainOutput validateCustomDomain(ValidateCustomDomainInput customDomainProperties) {
        return serviceManager
            .frontDoors()
            .validateCustomDomain(resourceGroupName, frontDoorName, customDomainProperties);
    }

    public FrontDoorImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public FrontDoorImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public FrontDoorImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    public FrontDoorImpl withFriendlyName(String friendlyName) {
        this.innerModel().withFriendlyName(friendlyName);
        return this;
    }

    public FrontDoorImpl withRoutingRules(List<RoutingRule> routingRules) {
        this.innerModel().withRoutingRules(routingRules);
        return this;
    }

    public FrontDoorImpl withLoadBalancingSettings(List<LoadBalancingSettingsModel> loadBalancingSettings) {
        this.innerModel().withLoadBalancingSettings(loadBalancingSettings);
        return this;
    }

    public FrontDoorImpl withHealthProbeSettings(List<HealthProbeSettingsModel> healthProbeSettings) {
        this.innerModel().withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    public FrontDoorImpl withBackendPools(List<BackendPool> backendPools) {
        this.innerModel().withBackendPools(backendPools);
        return this;
    }

    public FrontDoorImpl withFrontendEndpoints(List<FrontendEndpointInner> frontendEndpoints) {
        this.innerModel().withFrontendEndpoints(frontendEndpoints);
        return this;
    }

    public FrontDoorImpl withBackendPoolsSettings(BackendPoolsSettings backendPoolsSettings) {
        this.innerModel().withBackendPoolsSettings(backendPoolsSettings);
        return this;
    }

    public FrontDoorImpl withEnabledState(FrontDoorEnabledState enabledState) {
        this.innerModel().withEnabledState(enabledState);
        return this;
    }
}
