// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.frontdoor.fluent.FrontendEndpointsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontendEndpointInner;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsConfiguration;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointsListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in FrontendEndpointsClient. */
public final class FrontendEndpointsClientImpl implements FrontendEndpointsClient {
    /** The proxy service used to perform REST calls. */
    private final FrontendEndpointsService service;

    /** The service client containing this operation class. */
    private final FrontDoorManagementClientImpl client;

    /**
     * Initializes an instance of FrontendEndpointsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    FrontendEndpointsClientImpl(FrontDoorManagementClientImpl client) {
        this.service =
            RestProxy.create(FrontendEndpointsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for FrontDoorManagementClientFrontendEndpoints to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "FrontDoorManagementC")
    public interface FrontendEndpointsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FrontendEndpointsListResult>> listByFrontDoor(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("frontDoorName") String frontDoorName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints/{frontendEndpointName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FrontendEndpointInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("frontDoorName") String frontDoorName,
            @PathParam("frontendEndpointName") String frontendEndpointName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints/{frontendEndpointName}/enableHttps")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> enableHttps(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("frontDoorName") String frontDoorName,
            @PathParam("frontendEndpointName") String frontendEndpointName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CustomHttpsConfiguration customHttpsConfiguration,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints/{frontendEndpointName}/disableHttps")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> disableHttps(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("frontDoorName") String frontDoorName,
            @PathParam("frontendEndpointName") String frontendEndpointName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<FrontendEndpointsListResult>> listByFrontDoorNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Lists all of the frontend endpoints within a Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list frontend endpoints along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FrontendEndpointInner>> listByFrontDoorSinglePageAsync(
        String resourceGroupName, String frontDoorName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByFrontDoor(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            frontDoorName,
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<FrontendEndpointInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all of the frontend endpoints within a Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list frontend endpoints along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FrontendEndpointInner>> listByFrontDoorSinglePageAsync(
        String resourceGroupName, String frontDoorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByFrontDoor(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                frontDoorName,
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists all of the frontend endpoints within a Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list frontend endpoints as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<FrontendEndpointInner> listByFrontDoorAsync(String resourceGroupName, String frontDoorName) {
        return new PagedFlux<>(
            () -> listByFrontDoorSinglePageAsync(resourceGroupName, frontDoorName),
            nextLink -> listByFrontDoorNextSinglePageAsync(nextLink));
    }

    /**
     * Lists all of the frontend endpoints within a Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list frontend endpoints as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<FrontendEndpointInner> listByFrontDoorAsync(
        String resourceGroupName, String frontDoorName, Context context) {
        return new PagedFlux<>(
            () -> listByFrontDoorSinglePageAsync(resourceGroupName, frontDoorName, context),
            nextLink -> listByFrontDoorNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists all of the frontend endpoints within a Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list frontend endpoints as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FrontendEndpointInner> listByFrontDoor(String resourceGroupName, String frontDoorName) {
        return new PagedIterable<>(listByFrontDoorAsync(resourceGroupName, frontDoorName));
    }

    /**
     * Lists all of the frontend endpoints within a Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list frontend endpoints as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<FrontendEndpointInner> listByFrontDoor(
        String resourceGroupName, String frontDoorName, Context context) {
        return new PagedIterable<>(listByFrontDoorAsync(resourceGroupName, frontDoorName, context));
    }

    /**
     * Gets a Frontend endpoint with the specified name within the specified Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Frontend endpoint with the specified name within the specified Front Door along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<FrontendEndpointInner>> getWithResponseAsync(
        String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            frontDoorName,
                            frontendEndpointName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a Frontend endpoint with the specified name within the specified Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Frontend endpoint with the specified name within the specified Front Door along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<FrontendEndpointInner>> getWithResponseAsync(
        String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                frontDoorName,
                frontendEndpointName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Gets a Frontend endpoint with the specified name within the specified Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Frontend endpoint with the specified name within the specified Front Door on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<FrontendEndpointInner> getAsync(
        String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        return getWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a Frontend endpoint with the specified name within the specified Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Frontend endpoint with the specified name within the specified Front Door along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<FrontendEndpointInner> getWithResponse(
        String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        return getWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName, context).block();
    }

    /**
     * Gets a Frontend endpoint with the specified name within the specified Front Door.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Frontend endpoint with the specified name within the specified Front Door.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public FrontendEndpointInner get(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        return getWithResponse(resourceGroupName, frontDoorName, frontendEndpointName, Context.NONE).getValue();
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> enableHttpsWithResponseAsync(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        if (customHttpsConfiguration == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter customHttpsConfiguration is required and cannot be null."));
        } else {
            customHttpsConfiguration.validate();
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .enableHttps(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            frontDoorName,
                            frontendEndpointName,
                            apiVersion,
                            customHttpsConfiguration,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> enableHttpsWithResponseAsync(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        if (customHttpsConfiguration == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter customHttpsConfiguration is required and cannot be null."));
        } else {
            customHttpsConfiguration.validate();
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .enableHttps(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                frontDoorName,
                frontendEndpointName,
                apiVersion,
                customHttpsConfiguration,
                accept,
                context);
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginEnableHttpsAsync(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            enableHttpsWithResponseAsync(
                resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginEnableHttpsAsync(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            enableHttpsWithResponseAsync(
                resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginEnableHttps(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration) {
        return this
            .beginEnableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration)
            .getSyncPoller();
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginEnableHttps(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration,
        Context context) {
        return this
            .beginEnableHttpsAsync(
                resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration, context)
            .getSyncPoller();
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> enableHttpsAsync(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration) {
        return beginEnableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> enableHttpsAsync(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration,
        Context context) {
        return beginEnableHttpsAsync(
                resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void enableHttps(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration) {
        enableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration).block();
    }

    /**
     * Enables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param customHttpsConfiguration The configuration specifying how to enable HTTPS.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void enableHttps(
        String resourceGroupName,
        String frontDoorName,
        String frontendEndpointName,
        CustomHttpsConfiguration customHttpsConfiguration,
        Context context) {
        enableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration, context)
            .block();
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> disableHttpsWithResponseAsync(
        String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .disableHttps(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            frontDoorName,
                            frontendEndpointName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> disableHttpsWithResponseAsync(
        String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error(new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        final String apiVersion = "2021-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .disableHttps(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                frontDoorName,
                frontendEndpointName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDisableHttpsAsync(
        String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            disableHttpsWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDisableHttpsAsync(
        String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            disableHttpsWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDisableHttps(
        String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        return this.beginDisableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName).getSyncPoller();
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDisableHttps(
        String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        return this
            .beginDisableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, context)
            .getSyncPoller();
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> disableHttpsAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        return beginDisableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> disableHttpsAsync(
        String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        return beginDisableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void disableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        disableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName).block();
    }

    /**
     * Disables a frontendEndpoint for HTTPS traffic.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param frontDoorName Name of the Front Door which is globally unique.
     * @param frontendEndpointName Name of the Frontend endpoint which is unique within the Front Door.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void disableHttps(
        String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        disableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list frontend endpoints along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FrontendEndpointInner>> listByFrontDoorNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByFrontDoorNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<FrontendEndpointInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list frontend endpoints along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<FrontendEndpointInner>> listByFrontDoorNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByFrontDoorNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
