// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.resourcemanager.frontdoor.fluent.models.ManagedRuleSetDefinitionInner;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleGroupDefinition;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleSetDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ManagedRuleSetDefinitionImpl implements ManagedRuleSetDefinition {
    private ManagedRuleSetDefinitionInner innerObject;

    private final com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager;

    ManagedRuleSetDefinitionImpl(
        ManagedRuleSetDefinitionInner innerObject,
        com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    public String ruleSetId() {
        return this.innerModel().ruleSetId();
    }

    public String ruleSetType() {
        return this.innerModel().ruleSetType();
    }

    public String ruleSetVersion() {
        return this.innerModel().ruleSetVersion();
    }

    public List<ManagedRuleGroupDefinition> ruleGroups() {
        List<ManagedRuleGroupDefinition> inner = this.innerModel().ruleGroups();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public ManagedRuleSetDefinitionInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.frontdoor.FrontDoorManager manager() {
        return this.serviceManager;
    }
}
