// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.resourcemanager.frontdoor.fluent.models.PreconfiguredEndpointInner;
import com.azure.resourcemanager.frontdoor.models.EndpointType;
import com.azure.resourcemanager.frontdoor.models.PreconfiguredEndpoint;
import java.util.Collections;
import java.util.Map;

public final class PreconfiguredEndpointImpl implements PreconfiguredEndpoint {
    private PreconfiguredEndpointInner innerObject;

    private final com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager;

    PreconfiguredEndpointImpl(
        PreconfiguredEndpointInner innerObject, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public String description() {
        return this.innerModel().description();
    }

    public String endpoint() {
        return this.innerModel().endpoint();
    }

    public EndpointType endpointType() {
        return this.innerModel().endpointType();
    }

    public String backend() {
        return this.innerModel().backend();
    }

    public PreconfiguredEndpointInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.frontdoor.FrontDoorManager manager() {
        return this.serviceManager;
    }
}
