// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.fluent.models.ProfileInner;
import com.azure.resourcemanager.frontdoor.models.NetworkExperimentResourceState;
import com.azure.resourcemanager.frontdoor.models.Profile;
import com.azure.resourcemanager.frontdoor.models.ProfileUpdateModel;
import com.azure.resourcemanager.frontdoor.models.State;
import java.util.Collections;
import java.util.Map;

public final class ProfileImpl implements Profile, Profile.Definition, Profile.Update {
    private ProfileInner innerObject;

    private final com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public String location() {
        return this.innerModel().location();
    }

    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        } else {
            return Collections.emptyMap();
        }
    }

    public String etag() {
        return this.innerModel().etag();
    }

    public NetworkExperimentResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    public State enabledState() {
        return this.innerModel().enabledState();
    }

    public Region region() {
        return Region.fromName(this.regionName());
    }

    public String regionName() {
        return this.location();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ProfileInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.frontdoor.FrontDoorManager manager() {
        return this.serviceManager;
    }

    private String profileName;

    private String resourceGroupName;

    private ProfileUpdateModel updateParameters;

    public ProfileImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public Profile create() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getNetworkExperimentProfiles()
                .createOrUpdate(profileName, resourceGroupName, this.innerModel(), Context.NONE);
        return this;
    }

    public Profile create(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getNetworkExperimentProfiles()
                .createOrUpdate(profileName, resourceGroupName, this.innerModel(), context);
        return this;
    }

    ProfileImpl(String name, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = new ProfileInner();
        this.serviceManager = serviceManager;
        this.profileName = name;
    }

    public ProfileImpl update() {
        this.updateParameters = new ProfileUpdateModel();
        return this;
    }

    public Profile apply() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getNetworkExperimentProfiles()
                .update(resourceGroupName, profileName, updateParameters, Context.NONE);
        return this;
    }

    public Profile apply(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getNetworkExperimentProfiles()
                .update(resourceGroupName, profileName, updateParameters, context);
        return this;
    }

    ProfileImpl(ProfileInner innerObject, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.profileName = Utils.getValueFromIdByName(innerObject.id(), "NetworkExperimentProfiles");
    }

    public Profile refresh() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getNetworkExperimentProfiles()
                .getByResourceGroupWithResponse(resourceGroupName, profileName, Context.NONE)
                .getValue();
        return this;
    }

    public Profile refresh(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getNetworkExperimentProfiles()
                .getByResourceGroupWithResponse(resourceGroupName, profileName, context)
                .getValue();
        return this;
    }

    public ProfileImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    public ProfileImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    public ProfileImpl withTags(Map<String, String> tags) {
        if (isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        } else {
            this.updateParameters.withTags(tags);
            return this;
        }
    }

    public ProfileImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    public ProfileImpl withEnabledState(State enabledState) {
        if (isInCreateMode()) {
            this.innerModel().withEnabledState(enabledState);
            return this;
        } else {
            this.updateParameters.withEnabledState(enabledState);
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
