// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.fluent.ReportsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.LatencyScorecardInner;
import com.azure.resourcemanager.frontdoor.fluent.models.TimeseriesInner;
import com.azure.resourcemanager.frontdoor.models.LatencyScorecard;
import com.azure.resourcemanager.frontdoor.models.LatencyScorecardAggregationInterval;
import com.azure.resourcemanager.frontdoor.models.Reports;
import com.azure.resourcemanager.frontdoor.models.Timeseries;
import com.azure.resourcemanager.frontdoor.models.TimeseriesAggregationInterval;
import com.azure.resourcemanager.frontdoor.models.TimeseriesType;
import java.time.OffsetDateTime;

public final class ReportsImpl implements Reports {
    private static final ClientLogger LOGGER = new ClientLogger(ReportsImpl.class);

    private final ReportsClient innerClient;

    private final com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager;

    public ReportsImpl(ReportsClient innerClient, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<LatencyScorecard> getLatencyScorecardsWithResponse(
        String resourceGroupName,
        String profileName,
        String experimentName,
        LatencyScorecardAggregationInterval aggregationInterval,
        String endDateTimeUtc,
        String country,
        Context context) {
        Response<LatencyScorecardInner> inner =
            this
                .serviceClient()
                .getLatencyScorecardsWithResponse(
                    resourceGroupName,
                    profileName,
                    experimentName,
                    aggregationInterval,
                    endDateTimeUtc,
                    country,
                    context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new LatencyScorecardImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public LatencyScorecard getLatencyScorecards(
        String resourceGroupName,
        String profileName,
        String experimentName,
        LatencyScorecardAggregationInterval aggregationInterval) {
        LatencyScorecardInner inner =
            this
                .serviceClient()
                .getLatencyScorecards(resourceGroupName, profileName, experimentName, aggregationInterval);
        if (inner != null) {
            return new LatencyScorecardImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Timeseries> getTimeseriesWithResponse(
        String resourceGroupName,
        String profileName,
        String experimentName,
        OffsetDateTime startDateTimeUtc,
        OffsetDateTime endDateTimeUtc,
        TimeseriesAggregationInterval aggregationInterval,
        TimeseriesType timeseriesType,
        String endpointParam,
        String country,
        Context context) {
        Response<TimeseriesInner> inner =
            this
                .serviceClient()
                .getTimeseriesWithResponse(
                    resourceGroupName,
                    profileName,
                    experimentName,
                    startDateTimeUtc,
                    endDateTimeUtc,
                    aggregationInterval,
                    timeseriesType,
                    endpointParam,
                    country,
                    context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new TimeseriesImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Timeseries getTimeseries(
        String resourceGroupName,
        String profileName,
        String experimentName,
        OffsetDateTime startDateTimeUtc,
        OffsetDateTime endDateTimeUtc,
        TimeseriesAggregationInterval aggregationInterval,
        TimeseriesType timeseriesType) {
        TimeseriesInner inner =
            this
                .serviceClient()
                .getTimeseries(
                    resourceGroupName,
                    profileName,
                    experimentName,
                    startDateTimeUtc,
                    endDateTimeUtc,
                    aggregationInterval,
                    timeseriesType);
        if (inner != null) {
            return new TimeseriesImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ReportsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.frontdoor.FrontDoorManager manager() {
        return this.serviceManager;
    }
}
