// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.fluent.models.RulesEngineInner;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.RulesEngine;
import com.azure.resourcemanager.frontdoor.models.RulesEngineRule;
import java.util.Collections;
import java.util.List;

public final class RulesEngineImpl implements RulesEngine, RulesEngine.Definition, RulesEngine.Update {
    private RulesEngineInner innerObject;

    private final com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public FrontDoorResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    public List<RulesEngineRule> rules() {
        List<RulesEngineRule> inner = this.innerModel().rules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public RulesEngineInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.frontdoor.FrontDoorManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String frontDoorName;

    private String rulesEngineName;

    public RulesEngineImpl withExistingFrontDoor(String resourceGroupName, String frontDoorName) {
        this.resourceGroupName = resourceGroupName;
        this.frontDoorName = frontDoorName;
        return this;
    }

    public RulesEngine create() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getRulesEngines()
                .createOrUpdate(resourceGroupName, frontDoorName, rulesEngineName, this.innerModel(), Context.NONE);
        return this;
    }

    public RulesEngine create(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getRulesEngines()
                .createOrUpdate(resourceGroupName, frontDoorName, rulesEngineName, this.innerModel(), context);
        return this;
    }

    RulesEngineImpl(String name, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = new RulesEngineInner();
        this.serviceManager = serviceManager;
        this.rulesEngineName = name;
    }

    public RulesEngineImpl update() {
        return this;
    }

    public RulesEngine apply() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getRulesEngines()
                .createOrUpdate(resourceGroupName, frontDoorName, rulesEngineName, this.innerModel(), Context.NONE);
        return this;
    }

    public RulesEngine apply(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getRulesEngines()
                .createOrUpdate(resourceGroupName, frontDoorName, rulesEngineName, this.innerModel(), context);
        return this;
    }

    RulesEngineImpl(RulesEngineInner innerObject, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.frontDoorName = Utils.getValueFromIdByName(innerObject.id(), "frontDoors");
        this.rulesEngineName = Utils.getValueFromIdByName(innerObject.id(), "rulesEngines");
    }

    public RulesEngine refresh() {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getRulesEngines()
                .getWithResponse(resourceGroupName, frontDoorName, rulesEngineName, Context.NONE)
                .getValue();
        return this;
    }

    public RulesEngine refresh(Context context) {
        this.innerObject =
            serviceManager
                .serviceClient()
                .getRulesEngines()
                .getWithResponse(resourceGroupName, frontDoorName, rulesEngineName, context)
                .getValue();
        return this;
    }

    public RulesEngineImpl withRules(List<RulesEngineRule> rules) {
        this.innerModel().withRules(rules);
        return this;
    }
}
