// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.fluent.RulesEnginesClient;
import com.azure.resourcemanager.frontdoor.fluent.models.RulesEngineInner;
import com.azure.resourcemanager.frontdoor.models.RulesEngine;
import com.azure.resourcemanager.frontdoor.models.RulesEngines;

public final class RulesEnginesImpl implements RulesEngines {
    private static final ClientLogger LOGGER = new ClientLogger(RulesEnginesImpl.class);

    private final RulesEnginesClient innerClient;

    private final com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager;

    public RulesEnginesImpl(
        RulesEnginesClient innerClient, com.azure.resourcemanager.frontdoor.FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<RulesEngine> listByFrontDoor(String resourceGroupName, String frontDoorName) {
        PagedIterable<RulesEngineInner> inner = this.serviceClient().listByFrontDoor(resourceGroupName, frontDoorName);
        return Utils.mapPage(inner, inner1 -> new RulesEngineImpl(inner1, this.manager()));
    }

    public PagedIterable<RulesEngine> listByFrontDoor(String resourceGroupName, String frontDoorName, Context context) {
        PagedIterable<RulesEngineInner> inner =
            this.serviceClient().listByFrontDoor(resourceGroupName, frontDoorName, context);
        return Utils.mapPage(inner, inner1 -> new RulesEngineImpl(inner1, this.manager()));
    }

    public Response<RulesEngine> getWithResponse(
        String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        Response<RulesEngineInner> inner =
            this.serviceClient().getWithResponse(resourceGroupName, frontDoorName, rulesEngineName, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new RulesEngineImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public RulesEngine get(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        RulesEngineInner inner = this.serviceClient().get(resourceGroupName, frontDoorName, rulesEngineName);
        if (inner != null) {
            return new RulesEngineImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String frontDoorName, String rulesEngineName) {
        this.serviceClient().delete(resourceGroupName, frontDoorName, rulesEngineName);
    }

    public void delete(String resourceGroupName, String frontDoorName, String rulesEngineName, Context context) {
        this.serviceClient().delete(resourceGroupName, frontDoorName, rulesEngineName, context);
    }

    public RulesEngine getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        String rulesEngineName = Utils.getValueFromIdByName(id, "rulesEngines");
        if (rulesEngineName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'rulesEngines'.", id)));
        }
        return this.getWithResponse(resourceGroupName, frontDoorName, rulesEngineName, Context.NONE).getValue();
    }

    public Response<RulesEngine> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        String rulesEngineName = Utils.getValueFromIdByName(id, "rulesEngines");
        if (rulesEngineName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'rulesEngines'.", id)));
        }
        return this.getWithResponse(resourceGroupName, frontDoorName, rulesEngineName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        String rulesEngineName = Utils.getValueFromIdByName(id, "rulesEngines");
        if (rulesEngineName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'rulesEngines'.", id)));
        }
        this.delete(resourceGroupName, frontDoorName, rulesEngineName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        String rulesEngineName = Utils.getValueFromIdByName(id, "rulesEngines");
        if (rulesEngineName == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'rulesEngines'.", id)));
        }
        this.delete(resourceGroupName, frontDoorName, rulesEngineName, context);
    }

    private RulesEnginesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.frontdoor.FrontDoorManager manager() {
        return this.serviceManager;
    }

    public RulesEngineImpl define(String name) {
        return new RulesEngineImpl(name, this.manager());
    }
}
