// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.frontdoor.fluent.models.ExperimentUpdateProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Defines modifiable attributes of an Experiment. */
@Fluent
public final class ExperimentUpdateModel {
    /*
     * Resource tags.
     */
    @JsonProperty(value = "tags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    /*
     * The properties of a Profile
     */
    @JsonProperty(value = "properties")
    private ExperimentUpdateProperties innerProperties;

    /** Creates an instance of ExperimentUpdateModel class. */
    public ExperimentUpdateModel() {
    }

    /**
     * Get the tags property: Resource tags.
     *
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Resource tags.
     *
     * @param tags the tags value to set.
     * @return the ExperimentUpdateModel object itself.
     */
    public ExperimentUpdateModel withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the innerProperties property: The properties of a Profile.
     *
     * @return the innerProperties value.
     */
    private ExperimentUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the description property: The description of the intent or details of the Experiment.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The description of the intent or details of the Experiment.
     *
     * @param description the description value to set.
     * @return the ExperimentUpdateModel object itself.
     */
    public ExperimentUpdateModel withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExperimentUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the enabledState property: The state of the Experiment.
     *
     * @return the enabledState value.
     */
    public State enabledState() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledState();
    }

    /**
     * Set the enabledState property: The state of the Experiment.
     *
     * @param enabledState the enabledState value to set.
     * @return the ExperimentUpdateModel object itself.
     */
    public ExperimentUpdateModel withEnabledState(State enabledState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExperimentUpdateProperties();
        }
        this.innerProperties().withEnabledState(enabledState);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
