// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontDoorInner;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontendEndpointInner;
import java.util.List;
import java.util.Map;

/** An immutable client-side representation of FrontDoor. */
public interface FrontDoor {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     *
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     *
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     *
     * @return the type value.
     */
    String type();

    /**
     * Gets the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    String location();

    /**
     * Gets the tags property: Resource tags.
     *
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the resourceState property: Resource status of the Front Door or Front Door SubResource.
     *
     * <p>Resource status of the Front Door.
     *
     * @return the resourceState value.
     */
    FrontDoorResourceState resourceState();

    /**
     * Gets the provisioningState property: Provisioning state of the Front Door.
     *
     * @return the provisioningState value.
     */
    String provisioningState();

    /**
     * Gets the cname property: The host that each frontendEndpoint must CNAME to.
     *
     * @return the cname value.
     */
    String cname();

    /**
     * Gets the frontdoorId property: The Id of the frontdoor.
     *
     * @return the frontdoorId value.
     */
    String frontdoorId();

    /**
     * Gets the rulesEngines property: Rules Engine Configurations available to routing rules.
     *
     * @return the rulesEngines value.
     */
    List<RulesEngine> rulesEngines();

    /**
     * Gets the extendedProperties property: Key-Value pair representing additional properties for frontdoor.
     *
     * @return the extendedProperties value.
     */
    Map<String, String> extendedProperties();

    /**
     * Gets the friendlyName property: A friendly name for the frontDoor.
     *
     * @return the friendlyName value.
     */
    String friendlyName();

    /**
     * Gets the routingRules property: Routing rules associated with this Front Door.
     *
     * @return the routingRules value.
     */
    List<RoutingRule> routingRules();

    /**
     * Gets the loadBalancingSettings property: Load balancing settings associated with this Front Door instance.
     *
     * @return the loadBalancingSettings value.
     */
    List<LoadBalancingSettingsModel> loadBalancingSettings();

    /**
     * Gets the healthProbeSettings property: Health probe settings associated with this Front Door instance.
     *
     * @return the healthProbeSettings value.
     */
    List<HealthProbeSettingsModel> healthProbeSettings();

    /**
     * Gets the backendPools property: Backend pools available to routing rules.
     *
     * @return the backendPools value.
     */
    List<BackendPool> backendPools();

    /**
     * Gets the frontendEndpoints property: Frontend endpoints available to routing rules.
     *
     * @return the frontendEndpoints value.
     */
    List<FrontendEndpoint> frontendEndpoints();

    /**
     * Gets the backendPoolsSettings property: Settings for all backendPools.
     *
     * @return the backendPoolsSettings value.
     */
    BackendPoolsSettings backendPoolsSettings();

    /**
     * Gets the enabledState property: Operational status of the Front Door load balancer. Permitted values are
     * 'Enabled' or 'Disabled'.
     *
     * @return the enabledState value.
     */
    FrontDoorEnabledState enabledState();

    /**
     * Gets the region of the resource.
     *
     * @return the region of the resource.
     */
    Region region();

    /**
     * Gets the name of the resource region.
     *
     * @return the name of the resource region.
     */
    String regionName();

    /**
     * Gets the name of the resource group.
     *
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.frontdoor.fluent.models.FrontDoorInner object.
     *
     * @return the inner object.
     */
    FrontDoorInner innerModel();

    /** The entirety of the FrontDoor definition. */
    interface Definition
        extends DefinitionStages.Blank,
            DefinitionStages.WithLocation,
            DefinitionStages.WithResourceGroup,
            DefinitionStages.WithCreate {
    }
    /** The FrontDoor definition stages. */
    interface DefinitionStages {
        /** The first stage of the FrontDoor definition. */
        interface Blank extends WithLocation {
        }
        /** The stage of the FrontDoor definition allowing to specify location. */
        interface WithLocation {
            /**
             * Specifies the region for the resource.
             *
             * @param location The geo-location where the resource lives.
             * @return the next definition stage.
             */
            WithResourceGroup withRegion(Region location);

            /**
             * Specifies the region for the resource.
             *
             * @param location The geo-location where the resource lives.
             * @return the next definition stage.
             */
            WithResourceGroup withRegion(String location);
        }
        /** The stage of the FrontDoor definition allowing to specify parent resource. */
        interface WithResourceGroup {
            /**
             * Specifies resourceGroupName.
             *
             * @param resourceGroupName Name of the Resource group within the Azure subscription.
             * @return the next definition stage.
             */
            WithCreate withExistingResourceGroup(String resourceGroupName);
        }
        /**
         * The stage of the FrontDoor definition which contains all the minimum required properties for the resource to
         * be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithTags,
                DefinitionStages.WithFriendlyName,
                DefinitionStages.WithRoutingRules,
                DefinitionStages.WithLoadBalancingSettings,
                DefinitionStages.WithHealthProbeSettings,
                DefinitionStages.WithBackendPools,
                DefinitionStages.WithFrontendEndpoints,
                DefinitionStages.WithBackendPoolsSettings,
                DefinitionStages.WithEnabledState {
            /**
             * Executes the create request.
             *
             * @return the created resource.
             */
            FrontDoor create();

            /**
             * Executes the create request.
             *
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            FrontDoor create(Context context);
        }
        /** The stage of the FrontDoor definition allowing to specify tags. */
        interface WithTags {
            /**
             * Specifies the tags property: Resource tags..
             *
             * @param tags Resource tags.
             * @return the next definition stage.
             */
            WithCreate withTags(Map<String, String> tags);
        }
        /** The stage of the FrontDoor definition allowing to specify friendlyName. */
        interface WithFriendlyName {
            /**
             * Specifies the friendlyName property: A friendly name for the frontDoor.
             *
             * @param friendlyName A friendly name for the frontDoor.
             * @return the next definition stage.
             */
            WithCreate withFriendlyName(String friendlyName);
        }
        /** The stage of the FrontDoor definition allowing to specify routingRules. */
        interface WithRoutingRules {
            /**
             * Specifies the routingRules property: Routing rules associated with this Front Door..
             *
             * @param routingRules Routing rules associated with this Front Door.
             * @return the next definition stage.
             */
            WithCreate withRoutingRules(List<RoutingRule> routingRules);
        }
        /** The stage of the FrontDoor definition allowing to specify loadBalancingSettings. */
        interface WithLoadBalancingSettings {
            /**
             * Specifies the loadBalancingSettings property: Load balancing settings associated with this Front Door
             * instance..
             *
             * @param loadBalancingSettings Load balancing settings associated with this Front Door instance.
             * @return the next definition stage.
             */
            WithCreate withLoadBalancingSettings(List<LoadBalancingSettingsModel> loadBalancingSettings);
        }
        /** The stage of the FrontDoor definition allowing to specify healthProbeSettings. */
        interface WithHealthProbeSettings {
            /**
             * Specifies the healthProbeSettings property: Health probe settings associated with this Front Door
             * instance..
             *
             * @param healthProbeSettings Health probe settings associated with this Front Door instance.
             * @return the next definition stage.
             */
            WithCreate withHealthProbeSettings(List<HealthProbeSettingsModel> healthProbeSettings);
        }
        /** The stage of the FrontDoor definition allowing to specify backendPools. */
        interface WithBackendPools {
            /**
             * Specifies the backendPools property: Backend pools available to routing rules..
             *
             * @param backendPools Backend pools available to routing rules.
             * @return the next definition stage.
             */
            WithCreate withBackendPools(List<BackendPool> backendPools);
        }
        /** The stage of the FrontDoor definition allowing to specify frontendEndpoints. */
        interface WithFrontendEndpoints {
            /**
             * Specifies the frontendEndpoints property: Frontend endpoints available to routing rules..
             *
             * @param frontendEndpoints Frontend endpoints available to routing rules.
             * @return the next definition stage.
             */
            WithCreate withFrontendEndpoints(List<FrontendEndpointInner> frontendEndpoints);
        }
        /** The stage of the FrontDoor definition allowing to specify backendPoolsSettings. */
        interface WithBackendPoolsSettings {
            /**
             * Specifies the backendPoolsSettings property: Settings for all backendPools.
             *
             * @param backendPoolsSettings Settings for all backendPools.
             * @return the next definition stage.
             */
            WithCreate withBackendPoolsSettings(BackendPoolsSettings backendPoolsSettings);
        }
        /** The stage of the FrontDoor definition allowing to specify enabledState. */
        interface WithEnabledState {
            /**
             * Specifies the enabledState property: Operational status of the Front Door load balancer. Permitted values
             * are 'Enabled' or 'Disabled'.
             *
             * @param enabledState Operational status of the Front Door load balancer. Permitted values are 'Enabled' or
             *     'Disabled'.
             * @return the next definition stage.
             */
            WithCreate withEnabledState(FrontDoorEnabledState enabledState);
        }
    }
    /**
     * Begins update for the FrontDoor resource.
     *
     * @return the stage of resource update.
     */
    FrontDoor.Update update();

    /** The template for FrontDoor update. */
    interface Update
        extends UpdateStages.WithTags,
            UpdateStages.WithFriendlyName,
            UpdateStages.WithRoutingRules,
            UpdateStages.WithLoadBalancingSettings,
            UpdateStages.WithHealthProbeSettings,
            UpdateStages.WithBackendPools,
            UpdateStages.WithFrontendEndpoints,
            UpdateStages.WithBackendPoolsSettings,
            UpdateStages.WithEnabledState {
        /**
         * Executes the update request.
         *
         * @return the updated resource.
         */
        FrontDoor apply();

        /**
         * Executes the update request.
         *
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        FrontDoor apply(Context context);
    }
    /** The FrontDoor update stages. */
    interface UpdateStages {
        /** The stage of the FrontDoor update allowing to specify tags. */
        interface WithTags {
            /**
             * Specifies the tags property: Resource tags..
             *
             * @param tags Resource tags.
             * @return the next definition stage.
             */
            Update withTags(Map<String, String> tags);
        }
        /** The stage of the FrontDoor update allowing to specify friendlyName. */
        interface WithFriendlyName {
            /**
             * Specifies the friendlyName property: A friendly name for the frontDoor.
             *
             * @param friendlyName A friendly name for the frontDoor.
             * @return the next definition stage.
             */
            Update withFriendlyName(String friendlyName);
        }
        /** The stage of the FrontDoor update allowing to specify routingRules. */
        interface WithRoutingRules {
            /**
             * Specifies the routingRules property: Routing rules associated with this Front Door..
             *
             * @param routingRules Routing rules associated with this Front Door.
             * @return the next definition stage.
             */
            Update withRoutingRules(List<RoutingRule> routingRules);
        }
        /** The stage of the FrontDoor update allowing to specify loadBalancingSettings. */
        interface WithLoadBalancingSettings {
            /**
             * Specifies the loadBalancingSettings property: Load balancing settings associated with this Front Door
             * instance..
             *
             * @param loadBalancingSettings Load balancing settings associated with this Front Door instance.
             * @return the next definition stage.
             */
            Update withLoadBalancingSettings(List<LoadBalancingSettingsModel> loadBalancingSettings);
        }
        /** The stage of the FrontDoor update allowing to specify healthProbeSettings. */
        interface WithHealthProbeSettings {
            /**
             * Specifies the healthProbeSettings property: Health probe settings associated with this Front Door
             * instance..
             *
             * @param healthProbeSettings Health probe settings associated with this Front Door instance.
             * @return the next definition stage.
             */
            Update withHealthProbeSettings(List<HealthProbeSettingsModel> healthProbeSettings);
        }
        /** The stage of the FrontDoor update allowing to specify backendPools. */
        interface WithBackendPools {
            /**
             * Specifies the backendPools property: Backend pools available to routing rules..
             *
             * @param backendPools Backend pools available to routing rules.
             * @return the next definition stage.
             */
            Update withBackendPools(List<BackendPool> backendPools);
        }
        /** The stage of the FrontDoor update allowing to specify frontendEndpoints. */
        interface WithFrontendEndpoints {
            /**
             * Specifies the frontendEndpoints property: Frontend endpoints available to routing rules..
             *
             * @param frontendEndpoints Frontend endpoints available to routing rules.
             * @return the next definition stage.
             */
            Update withFrontendEndpoints(List<FrontendEndpointInner> frontendEndpoints);
        }
        /** The stage of the FrontDoor update allowing to specify backendPoolsSettings. */
        interface WithBackendPoolsSettings {
            /**
             * Specifies the backendPoolsSettings property: Settings for all backendPools.
             *
             * @param backendPoolsSettings Settings for all backendPools.
             * @return the next definition stage.
             */
            Update withBackendPoolsSettings(BackendPoolsSettings backendPoolsSettings);
        }
        /** The stage of the FrontDoor update allowing to specify enabledState. */
        interface WithEnabledState {
            /**
             * Specifies the enabledState property: Operational status of the Front Door load balancer. Permitted values
             * are 'Enabled' or 'Disabled'.
             *
             * @param enabledState Operational status of the Front Door load balancer. Permitted values are 'Enabled' or
             *     'Disabled'.
             * @return the next definition stage.
             */
            Update withEnabledState(FrontDoorEnabledState enabledState);
        }
    }
    /**
     * Refreshes the resource to sync with Azure.
     *
     * @return the refreshed resource.
     */
    FrontDoor refresh();

    /**
     * Refreshes the resource to sync with Azure.
     *
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    FrontDoor refresh(Context context);

    /**
     * Validates the custom domain mapping to ensure it maps to the correct Front Door endpoint in DNS.
     *
     * @param customDomainProperties Custom domain to be validated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of custom domain validation along with {@link Response}.
     */
    Response<ValidateCustomDomainOutput> validateCustomDomainWithResponse(
        ValidateCustomDomainInput customDomainProperties, Context context);

    /**
     * Validates the custom domain mapping to ensure it maps to the correct Front Door endpoint in DNS.
     *
     * @param customDomainProperties Custom domain to be validated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of custom domain validation.
     */
    ValidateCustomDomainOutput validateCustomDomain(ValidateCustomDomainInput customDomainProperties);
}
