// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'. */
public final class FrontDoorEnabledState extends ExpandableStringEnum<FrontDoorEnabledState> {
    /** Static value Enabled for FrontDoorEnabledState. */
    public static final FrontDoorEnabledState ENABLED = fromString("Enabled");

    /** Static value Disabled for FrontDoorEnabledState. */
    public static final FrontDoorEnabledState DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of FrontDoorEnabledState value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public FrontDoorEnabledState() {
    }

    /**
     * Creates or finds a FrontDoorEnabledState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding FrontDoorEnabledState.
     */
    @JsonCreator
    public static FrontDoorEnabledState fromString(String name) {
        return fromString(name, FrontDoorEnabledState.class);
    }

    /**
     * Gets known FrontDoorEnabledState values.
     *
     * @return known FrontDoorEnabledState values.
     */
    public static Collection<FrontDoorEnabledState> values() {
        return values(FrontDoorEnabledState.class);
    }
}
