// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Frontend endpoint used in routing rule. */
@Fluent
public class FrontendEndpointUpdateParameters {
    /*
     * The host name of the frontendEndpoint. Must be a domain name.
     */
    @JsonProperty(value = "hostName")
    private String hostname;

    /*
     * Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    @JsonProperty(value = "sessionAffinityEnabledState")
    private SessionAffinityEnabledState sessionAffinityEnabledState;

    /*
     * UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
     */
    @JsonProperty(value = "sessionAffinityTtlSeconds")
    private Integer sessionAffinityTtlSeconds;

    /*
     * Defines the Web Application Firewall policy for each host (if applicable)
     */
    @JsonProperty(value = "webApplicationFirewallPolicyLink")
    private FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink;

    /** Creates an instance of FrontendEndpointUpdateParameters class. */
    public FrontendEndpointUpdateParameters() {
    }

    /**
     * Get the hostname property: The host name of the frontendEndpoint. Must be a domain name.
     *
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Set the hostname property: The host name of the frontendEndpoint. Must be a domain name.
     *
     * @param hostname the hostname value to set.
     * @return the FrontendEndpointUpdateParameters object itself.
     */
    public FrontendEndpointUpdateParameters withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    /**
     * Get the sessionAffinityEnabledState property: Whether to allow session affinity on this host. Valid options are
     * 'Enabled' or 'Disabled'.
     *
     * @return the sessionAffinityEnabledState value.
     */
    public SessionAffinityEnabledState sessionAffinityEnabledState() {
        return this.sessionAffinityEnabledState;
    }

    /**
     * Set the sessionAffinityEnabledState property: Whether to allow session affinity on this host. Valid options are
     * 'Enabled' or 'Disabled'.
     *
     * @param sessionAffinityEnabledState the sessionAffinityEnabledState value to set.
     * @return the FrontendEndpointUpdateParameters object itself.
     */
    public FrontendEndpointUpdateParameters withSessionAffinityEnabledState(
        SessionAffinityEnabledState sessionAffinityEnabledState) {
        this.sessionAffinityEnabledState = sessionAffinityEnabledState;
        return this;
    }

    /**
     * Get the sessionAffinityTtlSeconds property: UNUSED. This field will be ignored. The TTL to use in seconds for
     * session affinity, if applicable.
     *
     * @return the sessionAffinityTtlSeconds value.
     */
    public Integer sessionAffinityTtlSeconds() {
        return this.sessionAffinityTtlSeconds;
    }

    /**
     * Set the sessionAffinityTtlSeconds property: UNUSED. This field will be ignored. The TTL to use in seconds for
     * session affinity, if applicable.
     *
     * @param sessionAffinityTtlSeconds the sessionAffinityTtlSeconds value to set.
     * @return the FrontendEndpointUpdateParameters object itself.
     */
    public FrontendEndpointUpdateParameters withSessionAffinityTtlSeconds(Integer sessionAffinityTtlSeconds) {
        this.sessionAffinityTtlSeconds = sessionAffinityTtlSeconds;
        return this;
    }

    /**
     * Get the webApplicationFirewallPolicyLink property: Defines the Web Application Firewall policy for each host (if
     * applicable).
     *
     * @return the webApplicationFirewallPolicyLink value.
     */
    public FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.webApplicationFirewallPolicyLink;
    }

    /**
     * Set the webApplicationFirewallPolicyLink property: Defines the Web Application Firewall policy for each host (if
     * applicable).
     *
     * @param webApplicationFirewallPolicyLink the webApplicationFirewallPolicyLink value to set.
     * @return the FrontendEndpointUpdateParameters object itself.
     */
    public FrontendEndpointUpdateParameters withWebApplicationFirewallPolicyLink(
        FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        this.webApplicationFirewallPolicyLink = webApplicationFirewallPolicyLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (webApplicationFirewallPolicyLink() != null) {
            webApplicationFirewallPolicyLink().validate();
        }
    }
}
