// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.resourcemanager.frontdoor.fluent.models.LatencyScorecardInner;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/** An immutable client-side representation of LatencyScorecard. */
public interface LatencyScorecard {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     *
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     *
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     *
     * @return the type value.
     */
    String type();

    /**
     * Gets the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    String location();

    /**
     * Gets the tags property: Resource tags.
     *
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the idPropertiesId property: The unique identifier of the Latency Scorecard.
     *
     * @return the idPropertiesId value.
     */
    String idPropertiesId();

    /**
     * Gets the namePropertiesName property: The name of the Latency Scorecard.
     *
     * @return the namePropertiesName value.
     */
    String namePropertiesName();

    /**
     * Gets the description property: The description of the Latency Scorecard.
     *
     * @return the description value.
     */
    String description();

    /**
     * Gets the endpointA property: The A endpoint in the scorecard.
     *
     * @return the endpointA value.
     */
    String endpointA();

    /**
     * Gets the endpointB property: The B endpoint in the scorecard.
     *
     * @return the endpointB value.
     */
    String endpointB();

    /**
     * Gets the startDateTimeUtc property: The start time of the Latency Scorecard in UTC.
     *
     * @return the startDateTimeUtc value.
     */
    OffsetDateTime startDateTimeUtc();

    /**
     * Gets the endDateTimeUtc property: The end time of the Latency Scorecard in UTC.
     *
     * @return the endDateTimeUtc value.
     */
    OffsetDateTime endDateTimeUtc();

    /**
     * Gets the country property: The country associated with the Latency Scorecard. Values are country ISO codes as
     * specified here- https://www.iso.org/iso-3166-country-codes.html.
     *
     * @return the country value.
     */
    String country();

    /**
     * Gets the latencyMetrics property: The latency metrics of the Latency Scorecard.
     *
     * @return the latencyMetrics value.
     */
    List<LatencyMetric> latencyMetrics();

    /**
     * Gets the inner com.azure.resourcemanager.frontdoor.fluent.models.LatencyScorecardInner object.
     *
     * @return the inner object.
     */
    LatencyScorecardInner innerModel();
}
