// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes a managed rule definition. */
@Immutable
public final class ManagedRuleDefinition {
    /*
     * Identifier for the managed rule.
     */
    @JsonProperty(value = "ruleId", access = JsonProperty.Access.WRITE_ONLY)
    private String ruleId;

    /*
     * Describes the default state for the managed rule.
     */
    @JsonProperty(value = "defaultState", access = JsonProperty.Access.WRITE_ONLY)
    private ManagedRuleEnabledState defaultState;

    /*
     * Describes the default action to be applied when the managed rule matches.
     */
    @JsonProperty(value = "defaultAction", access = JsonProperty.Access.WRITE_ONLY)
    private ActionType defaultAction;

    /*
     * Describes the functionality of the managed rule.
     */
    @JsonProperty(value = "description", access = JsonProperty.Access.WRITE_ONLY)
    private String description;

    /** Creates an instance of ManagedRuleDefinition class. */
    public ManagedRuleDefinition() {
    }

    /**
     * Get the ruleId property: Identifier for the managed rule.
     *
     * @return the ruleId value.
     */
    public String ruleId() {
        return this.ruleId;
    }

    /**
     * Get the defaultState property: Describes the default state for the managed rule.
     *
     * @return the defaultState value.
     */
    public ManagedRuleEnabledState defaultState() {
        return this.defaultState;
    }

    /**
     * Get the defaultAction property: Describes the default action to be applied when the managed rule matches.
     *
     * @return the defaultAction value.
     */
    public ActionType defaultAction() {
        return this.defaultAction;
    }

    /**
     * Get the description property: Describes the functionality of the managed rule.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
