// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Exclude variables from managed rule evaluation. */
@Fluent
public final class ManagedRuleExclusion {
    /*
     * The variable type to be excluded.
     */
    @JsonProperty(value = "matchVariable", required = true)
    private ManagedRuleExclusionMatchVariable matchVariable;

    /*
     * Comparison operator to apply to the selector when specifying which elements in the collection this exclusion
     * applies to.
     */
    @JsonProperty(value = "selectorMatchOperator", required = true)
    private ManagedRuleExclusionSelectorMatchOperator selectorMatchOperator;

    /*
     * Selector value for which elements in the collection this exclusion applies to.
     */
    @JsonProperty(value = "selector", required = true)
    private String selector;

    /** Creates an instance of ManagedRuleExclusion class. */
    public ManagedRuleExclusion() {
    }

    /**
     * Get the matchVariable property: The variable type to be excluded.
     *
     * @return the matchVariable value.
     */
    public ManagedRuleExclusionMatchVariable matchVariable() {
        return this.matchVariable;
    }

    /**
     * Set the matchVariable property: The variable type to be excluded.
     *
     * @param matchVariable the matchVariable value to set.
     * @return the ManagedRuleExclusion object itself.
     */
    public ManagedRuleExclusion withMatchVariable(ManagedRuleExclusionMatchVariable matchVariable) {
        this.matchVariable = matchVariable;
        return this;
    }

    /**
     * Get the selectorMatchOperator property: Comparison operator to apply to the selector when specifying which
     * elements in the collection this exclusion applies to.
     *
     * @return the selectorMatchOperator value.
     */
    public ManagedRuleExclusionSelectorMatchOperator selectorMatchOperator() {
        return this.selectorMatchOperator;
    }

    /**
     * Set the selectorMatchOperator property: Comparison operator to apply to the selector when specifying which
     * elements in the collection this exclusion applies to.
     *
     * @param selectorMatchOperator the selectorMatchOperator value to set.
     * @return the ManagedRuleExclusion object itself.
     */
    public ManagedRuleExclusion withSelectorMatchOperator(
        ManagedRuleExclusionSelectorMatchOperator selectorMatchOperator) {
        this.selectorMatchOperator = selectorMatchOperator;
        return this;
    }

    /**
     * Get the selector property: Selector value for which elements in the collection this exclusion applies to.
     *
     * @return the selector value.
     */
    public String selector() {
        return this.selector;
    }

    /**
     * Set the selector property: Selector value for which elements in the collection this exclusion applies to.
     *
     * @param selector the selector value to set.
     * @return the ManagedRuleExclusion object itself.
     */
    public ManagedRuleExclusion withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (matchVariable() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property matchVariable in model ManagedRuleExclusion"));
        }
        if (selectorMatchOperator() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property selectorMatchOperator in model ManagedRuleExclusion"));
        }
        if (selector() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property selector in model ManagedRuleExclusion"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleExclusion.class);
}
