// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Defines top-level WebApplicationFirewallPolicy configuration settings. */
@Fluent
public final class PolicySettings {
    /*
     * Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JsonProperty(value = "enabledState")
    private PolicyEnabledState enabledState;

    /*
     * Describes if it is in detection mode or prevention mode at policy level.
     */
    @JsonProperty(value = "mode")
    private PolicyMode mode;

    /*
     * If action type is redirect, this field represents redirect URL for the client.
     */
    @JsonProperty(value = "redirectUrl")
    private String redirectUrl;

    /*
     * If the action type is block, customer can override the response status code.
     */
    @JsonProperty(value = "customBlockResponseStatusCode")
    private Integer customBlockResponseStatusCode;

    /*
     * If the action type is block, customer can override the response body. The body must be specified in base64
     * encoding.
     */
    @JsonProperty(value = "customBlockResponseBody")
    private String customBlockResponseBody;

    /*
     * Describes if policy managed rules will inspect the request body content.
     */
    @JsonProperty(value = "requestBodyCheck")
    private PolicyRequestBodyCheck requestBodyCheck;

    /** Creates an instance of PolicySettings class. */
    public PolicySettings() {
    }

    /**
     * Get the enabledState property: Describes if the policy is in enabled or disabled state. Defaults to Enabled if
     * not specified.
     *
     * @return the enabledState value.
     */
    public PolicyEnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set the enabledState property: Describes if the policy is in enabled or disabled state. Defaults to Enabled if
     * not specified.
     *
     * @param enabledState the enabledState value to set.
     * @return the PolicySettings object itself.
     */
    public PolicySettings withEnabledState(PolicyEnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    /**
     * Get the mode property: Describes if it is in detection mode or prevention mode at policy level.
     *
     * @return the mode value.
     */
    public PolicyMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Describes if it is in detection mode or prevention mode at policy level.
     *
     * @param mode the mode value to set.
     * @return the PolicySettings object itself.
     */
    public PolicySettings withMode(PolicyMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the redirectUrl property: If action type is redirect, this field represents redirect URL for the client.
     *
     * @return the redirectUrl value.
     */
    public String redirectUrl() {
        return this.redirectUrl;
    }

    /**
     * Set the redirectUrl property: If action type is redirect, this field represents redirect URL for the client.
     *
     * @param redirectUrl the redirectUrl value to set.
     * @return the PolicySettings object itself.
     */
    public PolicySettings withRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    /**
     * Get the customBlockResponseStatusCode property: If the action type is block, customer can override the response
     * status code.
     *
     * @return the customBlockResponseStatusCode value.
     */
    public Integer customBlockResponseStatusCode() {
        return this.customBlockResponseStatusCode;
    }

    /**
     * Set the customBlockResponseStatusCode property: If the action type is block, customer can override the response
     * status code.
     *
     * @param customBlockResponseStatusCode the customBlockResponseStatusCode value to set.
     * @return the PolicySettings object itself.
     */
    public PolicySettings withCustomBlockResponseStatusCode(Integer customBlockResponseStatusCode) {
        this.customBlockResponseStatusCode = customBlockResponseStatusCode;
        return this;
    }

    /**
     * Get the customBlockResponseBody property: If the action type is block, customer can override the response body.
     * The body must be specified in base64 encoding.
     *
     * @return the customBlockResponseBody value.
     */
    public String customBlockResponseBody() {
        return this.customBlockResponseBody;
    }

    /**
     * Set the customBlockResponseBody property: If the action type is block, customer can override the response body.
     * The body must be specified in base64 encoding.
     *
     * @param customBlockResponseBody the customBlockResponseBody value to set.
     * @return the PolicySettings object itself.
     */
    public PolicySettings withCustomBlockResponseBody(String customBlockResponseBody) {
        this.customBlockResponseBody = customBlockResponseBody;
        return this;
    }

    /**
     * Get the requestBodyCheck property: Describes if policy managed rules will inspect the request body content.
     *
     * @return the requestBodyCheck value.
     */
    public PolicyRequestBodyCheck requestBodyCheck() {
        return this.requestBodyCheck;
    }

    /**
     * Set the requestBodyCheck property: Describes if policy managed rules will inspect the request body content.
     *
     * @param requestBodyCheck the requestBodyCheck value to set.
     * @return the PolicySettings object itself.
     */
    public PolicySettings withRequestBodyCheck(PolicyRequestBodyCheck requestBodyCheck) {
        this.requestBodyCheck = requestBodyCheck;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
