// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.frontdoor.fluent.models.RoutingRuleProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A routing rule represents a specification for traffic to treat and where to send it, along with health probe
 * information.
 */
@Fluent
public final class RoutingRule extends SubResource {
    /*
     * Properties of the Front Door Routing Rule
     */
    @JsonProperty(value = "properties")
    private RoutingRuleProperties innerProperties;

    /*
     * Resource name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /** Creates an instance of RoutingRule class. */
    public RoutingRule() {
    }

    /**
     * Get the innerProperties property: Properties of the Front Door Routing Rule.
     *
     * @return the innerProperties value.
     */
    private RoutingRuleProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Resource name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Resource name.
     *
     * @param name the name value to set.
     * @return the RoutingRule object itself.
     */
    public RoutingRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Resource type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public RoutingRule withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the resourceState property: Resource status of the Front Door or Front Door SubResource.
     *
     * <p>Resource status.
     *
     * @return the resourceState value.
     */
    public FrontDoorResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    /**
     * Get the frontendEndpoints property: Frontend endpoints associated with this rule.
     *
     * @return the frontendEndpoints value.
     */
    public List<SubResource> frontendEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendEndpoints();
    }

    /**
     * Set the frontendEndpoints property: Frontend endpoints associated with this rule.
     *
     * @param frontendEndpoints the frontendEndpoints value to set.
     * @return the RoutingRule object itself.
     */
    public RoutingRule withFrontendEndpoints(List<SubResource> frontendEndpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withFrontendEndpoints(frontendEndpoints);
        return this;
    }

    /**
     * Get the acceptedProtocols property: Protocol schemes to match for this rule.
     *
     * @return the acceptedProtocols value.
     */
    public List<FrontDoorProtocol> acceptedProtocols() {
        return this.innerProperties() == null ? null : this.innerProperties().acceptedProtocols();
    }

    /**
     * Set the acceptedProtocols property: Protocol schemes to match for this rule.
     *
     * @param acceptedProtocols the acceptedProtocols value to set.
     * @return the RoutingRule object itself.
     */
    public RoutingRule withAcceptedProtocols(List<FrontDoorProtocol> acceptedProtocols) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withAcceptedProtocols(acceptedProtocols);
        return this;
    }

    /**
     * Get the patternsToMatch property: The route patterns of the rule.
     *
     * @return the patternsToMatch value.
     */
    public List<String> patternsToMatch() {
        return this.innerProperties() == null ? null : this.innerProperties().patternsToMatch();
    }

    /**
     * Set the patternsToMatch property: The route patterns of the rule.
     *
     * @param patternsToMatch the patternsToMatch value to set.
     * @return the RoutingRule object itself.
     */
    public RoutingRule withPatternsToMatch(List<String> patternsToMatch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withPatternsToMatch(patternsToMatch);
        return this;
    }

    /**
     * Get the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     *
     * @return the enabledState value.
     */
    public RoutingRuleEnabledState enabledState() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledState();
    }

    /**
     * Set the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     *
     * @param enabledState the enabledState value to set.
     * @return the RoutingRule object itself.
     */
    public RoutingRule withEnabledState(RoutingRuleEnabledState enabledState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withEnabledState(enabledState);
        return this;
    }

    /**
     * Get the routeConfiguration property: A reference to the routing configuration.
     *
     * @return the routeConfiguration value.
     */
    public RouteConfiguration routeConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().routeConfiguration();
    }

    /**
     * Set the routeConfiguration property: A reference to the routing configuration.
     *
     * @param routeConfiguration the routeConfiguration value to set.
     * @return the RoutingRule object itself.
     */
    public RoutingRule withRouteConfiguration(RouteConfiguration routeConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withRouteConfiguration(routeConfiguration);
        return this;
    }

    /**
     * Get the rulesEngine property: A reference to a specific Rules Engine Configuration to apply to this route.
     *
     * @return the rulesEngine value.
     */
    public SubResource rulesEngine() {
        return this.innerProperties() == null ? null : this.innerProperties().rulesEngine();
    }

    /**
     * Set the rulesEngine property: A reference to a specific Rules Engine Configuration to apply to this route.
     *
     * @param rulesEngine the rulesEngine value to set.
     * @return the RoutingRule object itself.
     */
    public RoutingRule withRulesEngine(SubResource rulesEngine) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withRulesEngine(rulesEngine);
        return this;
    }

    /**
     * Get the webApplicationFirewallPolicyLink property: Defines the Web Application Firewall policy for each routing
     * rule (if applicable).
     *
     * @return the webApplicationFirewallPolicyLink value.
     */
    public RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.innerProperties() == null ? null : this.innerProperties().webApplicationFirewallPolicyLink();
    }

    /**
     * Set the webApplicationFirewallPolicyLink property: Defines the Web Application Firewall policy for each routing
     * rule (if applicable).
     *
     * @param webApplicationFirewallPolicyLink the webApplicationFirewallPolicyLink value to set.
     * @return the RoutingRule object itself.
     */
    public RoutingRule withWebApplicationFirewallPolicyLink(
        RoutingRuleUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleProperties();
        }
        this.innerProperties().withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
