// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Rules Engine Configuration to apply to a Routing Rule. */
@Fluent
public class RulesEngineUpdateParameters {
    /*
     * A list of rules that define a particular Rules Engine Configuration.
     */
    @JsonProperty(value = "rules")
    private List<RulesEngineRule> rules;

    /** Creates an instance of RulesEngineUpdateParameters class. */
    public RulesEngineUpdateParameters() {
    }

    /**
     * Get the rules property: A list of rules that define a particular Rules Engine Configuration.
     *
     * @return the rules value.
     */
    public List<RulesEngineRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: A list of rules that define a particular Rules Engine Configuration.
     *
     * @param rules the rules value to set.
     * @return the RulesEngineUpdateParameters object itself.
     */
    public RulesEngineUpdateParameters withRules(List<RulesEngineRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }
}
