// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.resourcemanager.frontdoor.fluent.models.TimeseriesInner;
import java.util.List;
import java.util.Map;

/** An immutable client-side representation of Timeseries. */
public interface Timeseries {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     *
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     *
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     *
     * @return the type value.
     */
    String type();

    /**
     * Gets the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    String location();

    /**
     * Gets the tags property: Resource tags.
     *
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the endpoint property: The endpoint associated with the Timeseries data point.
     *
     * @return the endpoint value.
     */
    String endpoint();

    /**
     * Gets the startDateTimeUtc property: The start DateTime of the Timeseries in UTC.
     *
     * @return the startDateTimeUtc value.
     */
    String startDateTimeUtc();

    /**
     * Gets the endDateTimeUtc property: The end DateTime of the Timeseries in UTC.
     *
     * @return the endDateTimeUtc value.
     */
    String endDateTimeUtc();

    /**
     * Gets the aggregationInterval property: The aggregation interval of the Timeseries.
     *
     * @return the aggregationInterval value.
     */
    AggregationInterval aggregationInterval();

    /**
     * Gets the timeseriesType property: The type of Timeseries.
     *
     * @return the timeseriesType value.
     */
    TimeseriesType timeseriesType();

    /**
     * Gets the country property: The country associated with the Timeseries. Values are country ISO codes as specified
     * here- https://www.iso.org/iso-3166-country-codes.html.
     *
     * @return the country value.
     */
    String country();

    /**
     * Gets the timeseriesData property: The set of data points for the timeseries.
     *
     * @return the timeseriesData value.
     */
    List<TimeseriesDataPoint> timeseriesData();

    /**
     * Gets the inner com.azure.resourcemanager.frontdoor.fluent.models.TimeseriesInner object.
     *
     * @return the inner object.
     */
    TimeseriesInner innerModel();
}
