// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.frontdoor.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Defines a timeseries datapoint used in a timeseries. */
@Fluent
public final class TimeseriesDataPoint {
    /*
     * The DateTime of the Timeseries data point in UTC
     */
    @JsonProperty(value = "dateTimeUTC")
    private String dateTimeUtc;

    /*
     * The Value of the Timeseries data point
     */
    @JsonProperty(value = "value")
    private Float value;

    /** Creates an instance of TimeseriesDataPoint class. */
    public TimeseriesDataPoint() {
    }

    /**
     * Get the dateTimeUtc property: The DateTime of the Timeseries data point in UTC.
     *
     * @return the dateTimeUtc value.
     */
    public String dateTimeUtc() {
        return this.dateTimeUtc;
    }

    /**
     * Set the dateTimeUtc property: The DateTime of the Timeseries data point in UTC.
     *
     * @param dateTimeUtc the dateTimeUtc value to set.
     * @return the TimeseriesDataPoint object itself.
     */
    public TimeseriesDataPoint withDateTimeUtc(String dateTimeUtc) {
        this.dateTimeUtc = dateTimeUtc;
        return this;
    }

    /**
     * Get the value property: The Value of the Timeseries data point.
     *
     * @return the value value.
     */
    public Float value() {
        return this.value;
    }

    /**
     * Set the value property: The Value of the Timeseries data point.
     *
     * @param value the value value to set.
     * @return the TimeseriesDataPoint object itself.
     */
    public TimeseriesDataPoint withValue(Float value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
