/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.fluent.FrontDoorManagementClient;
import com.azure.resourcemanager.frontdoor.implementation.EndpointsImpl;
import com.azure.resourcemanager.frontdoor.implementation.ExperimentsImpl;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorManagementClientBuilder;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorNameAvailabilitiesImpl;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorNameAvailabilityWithSubscriptionsImpl;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorsImpl;
import com.azure.resourcemanager.frontdoor.implementation.FrontendEndpointsImpl;
import com.azure.resourcemanager.frontdoor.implementation.ManagedRuleSetsImpl;
import com.azure.resourcemanager.frontdoor.implementation.NetworkExperimentProfilesImpl;
import com.azure.resourcemanager.frontdoor.implementation.PoliciesImpl;
import com.azure.resourcemanager.frontdoor.implementation.PreconfiguredEndpointsImpl;
import com.azure.resourcemanager.frontdoor.implementation.ReportsImpl;
import com.azure.resourcemanager.frontdoor.implementation.RulesEnginesImpl;
import com.azure.resourcemanager.frontdoor.models.Endpoints;
import com.azure.resourcemanager.frontdoor.models.Experiments;
import com.azure.resourcemanager.frontdoor.models.FrontDoorNameAvailabilities;
import com.azure.resourcemanager.frontdoor.models.FrontDoorNameAvailabilityWithSubscriptions;
import com.azure.resourcemanager.frontdoor.models.FrontDoors;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpoints;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleSets;
import com.azure.resourcemanager.frontdoor.models.NetworkExperimentProfiles;
import com.azure.resourcemanager.frontdoor.models.Policies;
import com.azure.resourcemanager.frontdoor.models.PreconfiguredEndpoints;
import com.azure.resourcemanager.frontdoor.models.Reports;
import com.azure.resourcemanager.frontdoor.models.RulesEngines;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class FrontDoorManager {
    private Policies policies;
    private ManagedRuleSets managedRuleSets;
    private FrontDoorNameAvailabilities frontDoorNameAvailabilities;
    private FrontDoorNameAvailabilityWithSubscriptions frontDoorNameAvailabilityWithSubscriptions;
    private FrontDoors frontDoors;
    private FrontendEndpoints frontendEndpoints;
    private Endpoints endpoints;
    private RulesEngines rulesEngines;
    private NetworkExperimentProfiles networkExperimentProfiles;
    private PreconfiguredEndpoints preconfiguredEndpoints;
    private Experiments experiments;
    private Reports reports;
    private final FrontDoorManagementClient clientObject;

    private FrontDoorManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new FrontDoorManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static FrontDoorManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return FrontDoorManager.configure().authenticate(credential, profile);
    }

    public static FrontDoorManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new FrontDoorManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Policies policies() {
        if (this.policies == null) {
            this.policies = new PoliciesImpl(this.clientObject.getPolicies(), this);
        }
        return this.policies;
    }

    public ManagedRuleSets managedRuleSets() {
        if (this.managedRuleSets == null) {
            this.managedRuleSets = new ManagedRuleSetsImpl(this.clientObject.getManagedRuleSets(), this);
        }
        return this.managedRuleSets;
    }

    public FrontDoorNameAvailabilities frontDoorNameAvailabilities() {
        if (this.frontDoorNameAvailabilities == null) {
            this.frontDoorNameAvailabilities = new FrontDoorNameAvailabilitiesImpl(this.clientObject.getFrontDoorNameAvailabilities(), this);
        }
        return this.frontDoorNameAvailabilities;
    }

    public FrontDoorNameAvailabilityWithSubscriptions frontDoorNameAvailabilityWithSubscriptions() {
        if (this.frontDoorNameAvailabilityWithSubscriptions == null) {
            this.frontDoorNameAvailabilityWithSubscriptions = new FrontDoorNameAvailabilityWithSubscriptionsImpl(this.clientObject.getFrontDoorNameAvailabilityWithSubscriptions(), this);
        }
        return this.frontDoorNameAvailabilityWithSubscriptions;
    }

    public FrontDoors frontDoors() {
        if (this.frontDoors == null) {
            this.frontDoors = new FrontDoorsImpl(this.clientObject.getFrontDoors(), this);
        }
        return this.frontDoors;
    }

    public FrontendEndpoints frontendEndpoints() {
        if (this.frontendEndpoints == null) {
            this.frontendEndpoints = new FrontendEndpointsImpl(this.clientObject.getFrontendEndpoints(), this);
        }
        return this.frontendEndpoints;
    }

    public Endpoints endpoints() {
        if (this.endpoints == null) {
            this.endpoints = new EndpointsImpl(this.clientObject.getEndpoints(), this);
        }
        return this.endpoints;
    }

    public RulesEngines rulesEngines() {
        if (this.rulesEngines == null) {
            this.rulesEngines = new RulesEnginesImpl(this.clientObject.getRulesEngines(), this);
        }
        return this.rulesEngines;
    }

    public NetworkExperimentProfiles networkExperimentProfiles() {
        if (this.networkExperimentProfiles == null) {
            this.networkExperimentProfiles = new NetworkExperimentProfilesImpl(this.clientObject.getNetworkExperimentProfiles(), this);
        }
        return this.networkExperimentProfiles;
    }

    public PreconfiguredEndpoints preconfiguredEndpoints() {
        if (this.preconfiguredEndpoints == null) {
            this.preconfiguredEndpoints = new PreconfiguredEndpointsImpl(this.clientObject.getPreconfiguredEndpoints(), this);
        }
        return this.preconfiguredEndpoints;
    }

    public Experiments experiments() {
        if (this.experiments == null) {
            this.experiments = new ExperimentsImpl(this.clientObject.getExperiments(), this);
        }
        return this.experiments;
    }

    public Reports reports() {
        if (this.reports == null) {
            this.reports = new ReportsImpl(this.clientObject.getReports(), this);
        }
        return this.reports;
    }

    public FrontDoorManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public FrontDoorManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.frontdoor").append("/").append("1.0.0-beta.3");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new FrontDoorManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

