/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.resourcemanager.frontdoor.fluent.models.FrontendEndpointInner;
import com.azure.resourcemanager.frontdoor.fluent.models.RulesEngineInner;
import com.azure.resourcemanager.frontdoor.models.BackendPool;
import com.azure.resourcemanager.frontdoor.models.BackendPoolsSettings;
import com.azure.resourcemanager.frontdoor.models.FrontDoorEnabledState;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.FrontDoorUpdateParameters;
import com.azure.resourcemanager.frontdoor.models.HealthProbeSettingsModel;
import com.azure.resourcemanager.frontdoor.models.LoadBalancingSettingsModel;
import com.azure.resourcemanager.frontdoor.models.RoutingRule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class FrontDoorProperties
extends FrontDoorUpdateParameters {
    @JsonProperty(value="resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private FrontDoorResourceState resourceState;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="cname", access=JsonProperty.Access.WRITE_ONLY)
    private String cname;
    @JsonProperty(value="frontdoorId", access=JsonProperty.Access.WRITE_ONLY)
    private String frontdoorId;
    @JsonProperty(value="rulesEngines", access=JsonProperty.Access.WRITE_ONLY)
    private List<RulesEngineInner> rulesEngines;
    @JsonProperty(value="extendedProperties", access=JsonProperty.Access.WRITE_ONLY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> extendedProperties;

    public FrontDoorResourceState resourceState() {
        return this.resourceState;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String cname() {
        return this.cname;
    }

    public String frontdoorId() {
        return this.frontdoorId;
    }

    public List<RulesEngineInner> rulesEngines() {
        return this.rulesEngines;
    }

    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    @Override
    public FrontDoorProperties withFriendlyName(String friendlyName) {
        super.withFriendlyName(friendlyName);
        return this;
    }

    @Override
    public FrontDoorProperties withRoutingRules(List<RoutingRule> routingRules) {
        super.withRoutingRules(routingRules);
        return this;
    }

    @Override
    public FrontDoorProperties withLoadBalancingSettings(List<LoadBalancingSettingsModel> loadBalancingSettings) {
        super.withLoadBalancingSettings(loadBalancingSettings);
        return this;
    }

    @Override
    public FrontDoorProperties withHealthProbeSettings(List<HealthProbeSettingsModel> healthProbeSettings) {
        super.withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    @Override
    public FrontDoorProperties withBackendPools(List<BackendPool> backendPools) {
        super.withBackendPools(backendPools);
        return this;
    }

    @Override
    public FrontDoorProperties withFrontendEndpoints(List<FrontendEndpointInner> frontendEndpoints) {
        super.withFrontendEndpoints(frontendEndpoints);
        return this;
    }

    @Override
    public FrontDoorProperties withBackendPoolsSettings(BackendPoolsSettings backendPoolsSettings) {
        super.withBackendPoolsSettings(backendPoolsSettings);
        return this;
    }

    @Override
    public FrontDoorProperties withEnabledState(FrontDoorEnabledState enabledState) {
        super.withEnabledState(enabledState);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.rulesEngines() != null) {
            this.rulesEngines().forEach(e -> e.validate());
        }
    }
}

