/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.resourcemanager.frontdoor.models.CustomHttpsConfiguration;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsProvisioningState;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsProvisioningSubstate;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointUpdateParameters;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.frontdoor.models.SessionAffinityEnabledState;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class FrontendEndpointProperties
extends FrontendEndpointUpdateParameters {
    @JsonProperty(value="resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private FrontDoorResourceState resourceState;
    @JsonProperty(value="customHttpsProvisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private CustomHttpsProvisioningState customHttpsProvisioningState;
    @JsonProperty(value="customHttpsProvisioningSubstate", access=JsonProperty.Access.WRITE_ONLY)
    private CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate;
    @JsonProperty(value="customHttpsConfiguration", access=JsonProperty.Access.WRITE_ONLY)
    private CustomHttpsConfiguration customHttpsConfiguration;

    public FrontDoorResourceState resourceState() {
        return this.resourceState;
    }

    public CustomHttpsProvisioningState customHttpsProvisioningState() {
        return this.customHttpsProvisioningState;
    }

    public CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate() {
        return this.customHttpsProvisioningSubstate;
    }

    public CustomHttpsConfiguration customHttpsConfiguration() {
        return this.customHttpsConfiguration;
    }

    @Override
    public FrontendEndpointProperties withHostname(String hostname) {
        super.withHostname(hostname);
        return this;
    }

    @Override
    public FrontendEndpointProperties withSessionAffinityEnabledState(SessionAffinityEnabledState sessionAffinityEnabledState) {
        super.withSessionAffinityEnabledState(sessionAffinityEnabledState);
        return this;
    }

    @Override
    public FrontendEndpointProperties withSessionAffinityTtlSeconds(Integer sessionAffinityTtlSeconds) {
        super.withSessionAffinityTtlSeconds(sessionAffinityTtlSeconds);
        return this;
    }

    @Override
    public FrontendEndpointProperties withWebApplicationFirewallPolicyLink(FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        super.withWebApplicationFirewallPolicyLink(webApplicationFirewallPolicyLink);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.customHttpsConfiguration() != null) {
            this.customHttpsConfiguration().validate();
        }
    }
}

