/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.fluent.models;

import com.azure.resourcemanager.frontdoor.models.CustomRuleList;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointLink;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleSetList;
import com.azure.resourcemanager.frontdoor.models.PolicyResourceState;
import com.azure.resourcemanager.frontdoor.models.PolicySettings;
import com.azure.resourcemanager.frontdoor.models.RoutingRuleLink;
import com.azure.resourcemanager.frontdoor.models.SecurityPolicyLink;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class WebApplicationFirewallPolicyProperties {
    @JsonProperty(value="policySettings")
    private PolicySettings policySettings;
    @JsonProperty(value="customRules")
    private CustomRuleList customRules;
    @JsonProperty(value="managedRules")
    private ManagedRuleSetList managedRules;
    @JsonProperty(value="frontendEndpointLinks", access=JsonProperty.Access.WRITE_ONLY)
    private List<FrontendEndpointLink> frontendEndpointLinks;
    @JsonProperty(value="routingRuleLinks", access=JsonProperty.Access.WRITE_ONLY)
    private List<RoutingRuleLink> routingRuleLinks;
    @JsonProperty(value="securityPolicyLinks", access=JsonProperty.Access.WRITE_ONLY)
    private List<SecurityPolicyLink> securityPolicyLinks;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private PolicyResourceState resourceState;

    public PolicySettings policySettings() {
        return this.policySettings;
    }

    public WebApplicationFirewallPolicyProperties withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    public CustomRuleList customRules() {
        return this.customRules;
    }

    public WebApplicationFirewallPolicyProperties withCustomRules(CustomRuleList customRules) {
        this.customRules = customRules;
        return this;
    }

    public ManagedRuleSetList managedRules() {
        return this.managedRules;
    }

    public WebApplicationFirewallPolicyProperties withManagedRules(ManagedRuleSetList managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    public List<FrontendEndpointLink> frontendEndpointLinks() {
        return this.frontendEndpointLinks;
    }

    public List<RoutingRuleLink> routingRuleLinks() {
        return this.routingRuleLinks;
    }

    public List<SecurityPolicyLink> securityPolicyLinks() {
        return this.securityPolicyLinks;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public PolicyResourceState resourceState() {
        return this.resourceState;
    }

    public void validate() {
        if (this.policySettings() != null) {
            this.policySettings().validate();
        }
        if (this.customRules() != null) {
            this.customRules().validate();
        }
        if (this.managedRules() != null) {
            this.managedRules().validate();
        }
        if (this.frontendEndpointLinks() != null) {
            this.frontendEndpointLinks().forEach(e -> e.validate());
        }
        if (this.routingRuleLinks() != null) {
            this.routingRuleLinks().forEach(e -> e.validate());
        }
        if (this.securityPolicyLinks() != null) {
            this.securityPolicyLinks().forEach(e -> e.validate());
        }
    }
}

