/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.frontdoor.fluent.EndpointsClient;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorManagementClientImpl;
import com.azure.resourcemanager.frontdoor.models.PurgeParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class EndpointsClientImpl
implements EndpointsClient {
    private final EndpointsService service;
    private final FrontDoorManagementClientImpl client;

    EndpointsClientImpl(FrontDoorManagementClientImpl client) {
        this.service = (EndpointsService)RestProxy.create(EndpointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> purgeContentWithResponseAsync(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (contentFilePaths == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentFilePaths is required and cannot be null."));
        }
        contentFilePaths.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.purgeContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, "2021-06-01", contentFilePaths, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> purgeContentWithResponseAsync(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (contentFilePaths == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentFilePaths is required and cannot be null."));
        }
        contentFilePaths.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.purgeContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, "2021-06-01", contentFilePaths, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginPurgeContentAsync(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.purgeContentWithResponseAsync(resourceGroupName, frontDoorName, contentFilePaths);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginPurgeContentAsync(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.purgeContentWithResponseAsync(resourceGroupName, frontDoorName, contentFilePaths, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPurgeContent(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths) {
        return this.beginPurgeContentAsync(resourceGroupName, frontDoorName, contentFilePaths).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPurgeContent(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths, Context context) {
        return this.beginPurgeContentAsync(resourceGroupName, frontDoorName, contentFilePaths, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> purgeContentAsync(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths) {
        return this.beginPurgeContentAsync(resourceGroupName, frontDoorName, contentFilePaths).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> purgeContentAsync(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths, Context context) {
        return this.beginPurgeContentAsync(resourceGroupName, frontDoorName, contentFilePaths, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeContent(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths) {
        this.purgeContentAsync(resourceGroupName, frontDoorName, contentFilePaths).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeContent(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths, Context context) {
        this.purgeContentAsync(resourceGroupName, frontDoorName, contentFilePaths, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FrontDoorManagementC")
    public static interface EndpointsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/purge")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> purgeContent(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="frontDoorName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") PurgeParameters var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

