/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.EndpointsClient;
import com.azure.resourcemanager.frontdoor.models.Endpoints;
import com.azure.resourcemanager.frontdoor.models.PurgeParameters;

public final class EndpointsImpl
implements Endpoints {
    private static final ClientLogger LOGGER = new ClientLogger(EndpointsImpl.class);
    private final EndpointsClient innerClient;
    private final FrontDoorManager serviceManager;

    public EndpointsImpl(EndpointsClient innerClient, FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void purgeContent(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths) {
        this.serviceClient().purgeContent(resourceGroupName, frontDoorName, contentFilePaths);
    }

    @Override
    public void purgeContent(String resourceGroupName, String frontDoorName, PurgeParameters contentFilePaths, Context context) {
        this.serviceClient().purgeContent(resourceGroupName, frontDoorName, contentFilePaths, context);
    }

    private EndpointsClient serviceClient() {
        return this.innerClient;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }
}

