/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.models.ExperimentInner;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.Endpoint;
import com.azure.resourcemanager.frontdoor.models.Experiment;
import com.azure.resourcemanager.frontdoor.models.ExperimentUpdateModel;
import com.azure.resourcemanager.frontdoor.models.NetworkExperimentResourceState;
import com.azure.resourcemanager.frontdoor.models.State;
import java.util.Collections;
import java.util.Map;

public final class ExperimentImpl
implements Experiment,
Experiment.Definition,
Experiment.Update {
    private ExperimentInner innerObject;
    private final FrontDoorManager serviceManager;
    private String resourceGroupName;
    private String profileName;
    private String experimentName;
    private ExperimentUpdateModel updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Endpoint endpointA() {
        return this.innerModel().endpointA();
    }

    @Override
    public Endpoint endpointB() {
        return this.innerModel().endpointB();
    }

    @Override
    public State enabledState() {
        return this.innerModel().enabledState();
    }

    @Override
    public NetworkExperimentResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    @Override
    public String status() {
        return this.innerModel().status();
    }

    @Override
    public String scriptFileUri() {
        return this.innerModel().scriptFileUri();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ExperimentInner innerModel() {
        return this.innerObject;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }

    @Override
    public ExperimentImpl withExistingNetworkExperimentProfile(String resourceGroupName, String profileName) {
        this.resourceGroupName = resourceGroupName;
        this.profileName = profileName;
        return this;
    }

    @Override
    public Experiment create() {
        this.innerObject = this.serviceManager.serviceClient().getExperiments().createOrUpdate(this.resourceGroupName, this.profileName, this.experimentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Experiment create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getExperiments().createOrUpdate(this.resourceGroupName, this.profileName, this.experimentName, this.innerModel(), context);
        return this;
    }

    ExperimentImpl(String name, FrontDoorManager serviceManager) {
        this.innerObject = new ExperimentInner();
        this.serviceManager = serviceManager;
        this.experimentName = name;
    }

    @Override
    public ExperimentImpl update() {
        this.updateParameters = new ExperimentUpdateModel();
        return this;
    }

    @Override
    public Experiment apply() {
        this.innerObject = this.serviceManager.serviceClient().getExperiments().update(this.resourceGroupName, this.profileName, this.experimentName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Experiment apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getExperiments().update(this.resourceGroupName, this.profileName, this.experimentName, this.updateParameters, context);
        return this;
    }

    ExperimentImpl(ExperimentInner innerObject, FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.profileName = Utils.getValueFromIdByName(innerObject.id(), "NetworkExperimentProfiles");
        this.experimentName = Utils.getValueFromIdByName(innerObject.id(), "Experiments");
    }

    @Override
    public Experiment refresh() {
        this.innerObject = (ExperimentInner)((Object)this.serviceManager.serviceClient().getExperiments().getWithResponse(this.resourceGroupName, this.profileName, this.experimentName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Experiment refresh(Context context) {
        this.innerObject = (ExperimentInner)((Object)this.serviceManager.serviceClient().getExperiments().getWithResponse(this.resourceGroupName, this.profileName, this.experimentName, context).getValue());
        return this;
    }

    @Override
    public ExperimentImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ExperimentImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ExperimentImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ExperimentImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.innerModel().withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public ExperimentImpl withEndpointA(Endpoint endpointA) {
        this.innerModel().withEndpointA(endpointA);
        return this;
    }

    @Override
    public ExperimentImpl withEndpointB(Endpoint endpointB) {
        this.innerModel().withEndpointB(endpointB);
        return this;
    }

    @Override
    public ExperimentImpl withEnabledState(State enabledState) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnabledState(enabledState);
            return this;
        }
        this.updateParameters.withEnabledState(enabledState);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

