/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.frontdoor.fluent.ExperimentsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.ExperimentInner;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorManagementClientImpl;
import com.azure.resourcemanager.frontdoor.models.ExperimentList;
import com.azure.resourcemanager.frontdoor.models.ExperimentUpdateModel;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ExperimentsClientImpl
implements ExperimentsClient {
    private final ExperimentsService service;
    private final FrontDoorManagementClientImpl client;

    ExperimentsClientImpl(FrontDoorManagementClientImpl client) {
        this.service = (ExperimentsService)RestProxy.create(ExperimentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExperimentInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfile(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExperimentList)res.getValue()).value(), ((ExperimentList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExperimentInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfile(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExperimentList)res.getValue()).value(), ((ExperimentList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ExperimentInner> listByProfileAsync(String resourceGroupName, String profileName) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ExperimentInner> listByProfileAsync(String resourceGroupName, String profileName, Context context) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName, context), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExperimentInner> listByProfile(String resourceGroupName, String profileName) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExperimentInner> listByProfile(String resourceGroupName, String profileName, Context context) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExperimentInner>> getWithResponseAsync(String resourceGroupName, String profileName, String experimentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExperimentInner>> getWithResponseAsync(String resourceGroupName, String profileName, String experimentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExperimentInner> getAsync(String resourceGroupName, String profileName, String experimentName) {
        return this.getWithResponseAsync(resourceGroupName, profileName, experimentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ExperimentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExperimentInner> getWithResponse(String resourceGroupName, String profileName, String experimentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, experimentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentInner get(String resourceGroupName, String profileName, String experimentName) {
        return (ExperimentInner)((Object)this.getWithResponse(resourceGroupName, profileName, experimentName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ExperimentInner>, ExperimentInner> beginCreateOrUpdateAsync(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, profileName, experimentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ExperimentInner.class), (Type)((Object)ExperimentInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ExperimentInner>, ExperimentInner> beginCreateOrUpdateAsync(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, profileName, experimentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ExperimentInner.class), (Type)((Object)ExperimentInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExperimentInner>, ExperimentInner> beginCreateOrUpdate(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, profileName, experimentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExperimentInner>, ExperimentInner> beginCreateOrUpdate(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, profileName, experimentName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExperimentInner> createOrUpdateAsync(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, profileName, experimentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExperimentInner> createOrUpdateAsync(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, profileName, experimentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentInner createOrUpdate(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters) {
        return (ExperimentInner)((Object)this.createOrUpdateAsync(resourceGroupName, profileName, experimentName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentInner createOrUpdate(String resourceGroupName, String profileName, String experimentName, ExperimentInner parameters, Context context) {
        return (ExperimentInner)((Object)this.createOrUpdateAsync(resourceGroupName, profileName, experimentName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ExperimentInner>, ExperimentInner> beginUpdateAsync(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, experimentName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ExperimentInner.class), (Type)((Object)ExperimentInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ExperimentInner>, ExperimentInner> beginUpdateAsync(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, experimentName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ExperimentInner.class), (Type)((Object)ExperimentInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExperimentInner>, ExperimentInner> beginUpdate(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters) {
        return this.beginUpdateAsync(resourceGroupName, profileName, experimentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExperimentInner>, ExperimentInner> beginUpdate(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, experimentName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExperimentInner> updateAsync(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters) {
        return this.beginUpdateAsync(resourceGroupName, profileName, experimentName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExperimentInner> updateAsync(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, experimentName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentInner update(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters) {
        return (ExperimentInner)((Object)this.updateAsync(resourceGroupName, profileName, experimentName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentInner update(String resourceGroupName, String profileName, String experimentName, ExperimentUpdateModel parameters, Context context) {
        return (ExperimentInner)((Object)this.updateAsync(resourceGroupName, profileName, experimentName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String experimentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String experimentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String experimentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, experimentName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String experimentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, experimentName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String experimentName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, experimentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String experimentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, experimentName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String experimentName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, experimentName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String experimentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, experimentName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String experimentName) {
        this.deleteAsync(resourceGroupName, profileName, experimentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String experimentName, Context context) {
        this.deleteAsync(resourceGroupName, profileName, experimentName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExperimentInner>> listByProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExperimentList)res.getValue()).value(), ((ExperimentList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExperimentInner>> listByProfileNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExperimentList)res.getValue()).value(), ((ExperimentList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FrontDoorManagementC")
    public static interface ExperimentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExperimentList>> listByProfile(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="profileName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExperimentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="experimentName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="experimentName") String var6, @BodyParam(value="application/json") ExperimentInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="experimentName") String var6, @BodyParam(value="application/json") ExperimentUpdateModel var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="experimentName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExperimentList>> listByProfileNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

