/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.ExperimentsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.ExperimentInner;
import com.azure.resourcemanager.frontdoor.implementation.ExperimentImpl;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.Experiment;
import com.azure.resourcemanager.frontdoor.models.Experiments;

public final class ExperimentsImpl
implements Experiments {
    private static final ClientLogger LOGGER = new ClientLogger(ExperimentsImpl.class);
    private final ExperimentsClient innerClient;
    private final FrontDoorManager serviceManager;

    public ExperimentsImpl(ExperimentsClient innerClient, FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Experiment> listByProfile(String resourceGroupName, String profileName) {
        PagedIterable<ExperimentInner> inner = this.serviceClient().listByProfile(resourceGroupName, profileName);
        return Utils.mapPage(inner, inner1 -> new ExperimentImpl((ExperimentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Experiment> listByProfile(String resourceGroupName, String profileName, Context context) {
        PagedIterable<ExperimentInner> inner = this.serviceClient().listByProfile(resourceGroupName, profileName, context);
        return Utils.mapPage(inner, inner1 -> new ExperimentImpl((ExperimentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Experiment> getWithResponse(String resourceGroupName, String profileName, String experimentName, Context context) {
        Response<ExperimentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, profileName, experimentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ExperimentImpl((ExperimentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Experiment get(String resourceGroupName, String profileName, String experimentName) {
        ExperimentInner inner = this.serviceClient().get(resourceGroupName, profileName, experimentName);
        if (inner != null) {
            return new ExperimentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String profileName, String experimentName) {
        this.serviceClient().delete(resourceGroupName, profileName, experimentName);
    }

    @Override
    public void delete(String resourceGroupName, String profileName, String experimentName, Context context) {
        this.serviceClient().delete(resourceGroupName, profileName, experimentName, context);
    }

    @Override
    public Experiment getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String profileName = Utils.getValueFromIdByName(id, "NetworkExperimentProfiles");
        if (profileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'NetworkExperimentProfiles'.", id)));
        }
        String experimentName = Utils.getValueFromIdByName(id, "Experiments");
        if (experimentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'Experiments'.", id)));
        }
        return (Experiment)this.getWithResponse(resourceGroupName, profileName, experimentName, Context.NONE).getValue();
    }

    @Override
    public Response<Experiment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String profileName = Utils.getValueFromIdByName(id, "NetworkExperimentProfiles");
        if (profileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'NetworkExperimentProfiles'.", id)));
        }
        String experimentName = Utils.getValueFromIdByName(id, "Experiments");
        if (experimentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'Experiments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, profileName, experimentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String profileName = Utils.getValueFromIdByName(id, "NetworkExperimentProfiles");
        if (profileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'NetworkExperimentProfiles'.", id)));
        }
        String experimentName = Utils.getValueFromIdByName(id, "Experiments");
        if (experimentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'Experiments'.", id)));
        }
        this.delete(resourceGroupName, profileName, experimentName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String profileName = Utils.getValueFromIdByName(id, "NetworkExperimentProfiles");
        if (profileName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'NetworkExperimentProfiles'.", id)));
        }
        String experimentName = Utils.getValueFromIdByName(id, "Experiments");
        if (experimentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'Experiments'.", id)));
        }
        this.delete(resourceGroupName, profileName, experimentName, context);
    }

    private ExperimentsClient serviceClient() {
        return this.innerClient;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }

    @Override
    public ExperimentImpl define(String name) {
        return new ExperimentImpl(name, this.manager());
    }
}

