/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontDoorInner;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontendEndpointInner;
import com.azure.resourcemanager.frontdoor.fluent.models.RulesEngineInner;
import com.azure.resourcemanager.frontdoor.implementation.FrontendEndpointImpl;
import com.azure.resourcemanager.frontdoor.implementation.RulesEngineImpl;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.BackendPool;
import com.azure.resourcemanager.frontdoor.models.BackendPoolsSettings;
import com.azure.resourcemanager.frontdoor.models.FrontDoor;
import com.azure.resourcemanager.frontdoor.models.FrontDoorEnabledState;
import com.azure.resourcemanager.frontdoor.models.FrontDoorResourceState;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpoint;
import com.azure.resourcemanager.frontdoor.models.HealthProbeSettingsModel;
import com.azure.resourcemanager.frontdoor.models.LoadBalancingSettingsModel;
import com.azure.resourcemanager.frontdoor.models.RoutingRule;
import com.azure.resourcemanager.frontdoor.models.RulesEngine;
import com.azure.resourcemanager.frontdoor.models.ValidateCustomDomainInput;
import com.azure.resourcemanager.frontdoor.models.ValidateCustomDomainOutput;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class FrontDoorImpl
implements FrontDoor,
FrontDoor.Definition,
FrontDoor.Update {
    private FrontDoorInner innerObject;
    private final FrontDoorManager serviceManager;
    private String resourceGroupName;
    private String frontDoorName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public FrontDoorResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String cname() {
        return this.innerModel().cname();
    }

    @Override
    public String frontdoorId() {
        return this.innerModel().frontdoorId();
    }

    @Override
    public List<RulesEngine> rulesEngines() {
        List<RulesEngineInner> inner = this.innerModel().rulesEngines();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new RulesEngineImpl((RulesEngineInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> extendedProperties() {
        Map<String, String> inner = this.innerModel().extendedProperties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String friendlyName() {
        return this.innerModel().friendlyName();
    }

    @Override
    public List<RoutingRule> routingRules() {
        List<RoutingRule> inner = this.innerModel().routingRules();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<LoadBalancingSettingsModel> loadBalancingSettings() {
        List<LoadBalancingSettingsModel> inner = this.innerModel().loadBalancingSettings();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<HealthProbeSettingsModel> healthProbeSettings() {
        List<HealthProbeSettingsModel> inner = this.innerModel().healthProbeSettings();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<BackendPool> backendPools() {
        List<BackendPool> inner = this.innerModel().backendPools();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<FrontendEndpoint> frontendEndpoints() {
        List<FrontendEndpointInner> inner = this.innerModel().frontendEndpoints();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new FrontendEndpointImpl((FrontendEndpointInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public BackendPoolsSettings backendPoolsSettings() {
        return this.innerModel().backendPoolsSettings();
    }

    @Override
    public FrontDoorEnabledState enabledState() {
        return this.innerModel().enabledState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public FrontDoorInner innerModel() {
        return this.innerObject;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }

    @Override
    public FrontDoorImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public FrontDoor create() {
        this.innerObject = this.serviceManager.serviceClient().getFrontDoors().createOrUpdate(this.resourceGroupName, this.frontDoorName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public FrontDoor create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFrontDoors().createOrUpdate(this.resourceGroupName, this.frontDoorName, this.innerModel(), context);
        return this;
    }

    FrontDoorImpl(String name, FrontDoorManager serviceManager) {
        this.innerObject = new FrontDoorInner();
        this.serviceManager = serviceManager;
        this.frontDoorName = name;
    }

    @Override
    public FrontDoorImpl update() {
        return this;
    }

    @Override
    public FrontDoor apply() {
        this.innerObject = this.serviceManager.serviceClient().getFrontDoors().createOrUpdate(this.resourceGroupName, this.frontDoorName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public FrontDoor apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFrontDoors().createOrUpdate(this.resourceGroupName, this.frontDoorName, this.innerModel(), context);
        return this;
    }

    FrontDoorImpl(FrontDoorInner innerObject, FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.frontDoorName = Utils.getValueFromIdByName(innerObject.id(), "frontDoors");
    }

    @Override
    public FrontDoor refresh() {
        this.innerObject = (FrontDoorInner)((Object)this.serviceManager.serviceClient().getFrontDoors().getByResourceGroupWithResponse(this.resourceGroupName, this.frontDoorName, Context.NONE).getValue());
        return this;
    }

    @Override
    public FrontDoor refresh(Context context) {
        this.innerObject = (FrontDoorInner)((Object)this.serviceManager.serviceClient().getFrontDoors().getByResourceGroupWithResponse(this.resourceGroupName, this.frontDoorName, context).getValue());
        return this;
    }

    @Override
    public Response<ValidateCustomDomainOutput> validateCustomDomainWithResponse(ValidateCustomDomainInput customDomainProperties, Context context) {
        return this.serviceManager.frontDoors().validateCustomDomainWithResponse(this.resourceGroupName, this.frontDoorName, customDomainProperties, context);
    }

    @Override
    public ValidateCustomDomainOutput validateCustomDomain(ValidateCustomDomainInput customDomainProperties) {
        return this.serviceManager.frontDoors().validateCustomDomain(this.resourceGroupName, this.frontDoorName, customDomainProperties);
    }

    @Override
    public FrontDoorImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public FrontDoorImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public FrontDoorImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public FrontDoorImpl withFriendlyName(String friendlyName) {
        this.innerModel().withFriendlyName(friendlyName);
        return this;
    }

    @Override
    public FrontDoorImpl withRoutingRules(List<RoutingRule> routingRules) {
        this.innerModel().withRoutingRules(routingRules);
        return this;
    }

    @Override
    public FrontDoorImpl withLoadBalancingSettings(List<LoadBalancingSettingsModel> loadBalancingSettings) {
        this.innerModel().withLoadBalancingSettings(loadBalancingSettings);
        return this;
    }

    @Override
    public FrontDoorImpl withHealthProbeSettings(List<HealthProbeSettingsModel> healthProbeSettings) {
        this.innerModel().withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    @Override
    public FrontDoorImpl withBackendPools(List<BackendPool> backendPools) {
        this.innerModel().withBackendPools(backendPools);
        return this;
    }

    @Override
    public FrontDoorImpl withFrontendEndpoints(List<FrontendEndpointInner> frontendEndpoints) {
        this.innerModel().withFrontendEndpoints(frontendEndpoints);
        return this;
    }

    @Override
    public FrontDoorImpl withBackendPoolsSettings(BackendPoolsSettings backendPoolsSettings) {
        this.innerModel().withBackendPoolsSettings(backendPoolsSettings);
        return this;
    }

    @Override
    public FrontDoorImpl withEnabledState(FrontDoorEnabledState enabledState) {
        this.innerModel().withEnabledState(enabledState);
        return this;
    }
}

