/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.frontdoor.fluent.EndpointsClient;
import com.azure.resourcemanager.frontdoor.fluent.ExperimentsClient;
import com.azure.resourcemanager.frontdoor.fluent.FrontDoorManagementClient;
import com.azure.resourcemanager.frontdoor.fluent.FrontDoorNameAvailabilitiesClient;
import com.azure.resourcemanager.frontdoor.fluent.FrontDoorNameAvailabilityWithSubscriptionsClient;
import com.azure.resourcemanager.frontdoor.fluent.FrontDoorsClient;
import com.azure.resourcemanager.frontdoor.fluent.FrontendEndpointsClient;
import com.azure.resourcemanager.frontdoor.fluent.ManagedRuleSetsClient;
import com.azure.resourcemanager.frontdoor.fluent.NetworkExperimentProfilesClient;
import com.azure.resourcemanager.frontdoor.fluent.PoliciesClient;
import com.azure.resourcemanager.frontdoor.fluent.PreconfiguredEndpointsClient;
import com.azure.resourcemanager.frontdoor.fluent.ReportsClient;
import com.azure.resourcemanager.frontdoor.fluent.RulesEnginesClient;
import com.azure.resourcemanager.frontdoor.implementation.EndpointsClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.ExperimentsClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorManagementClientBuilder;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorNameAvailabilitiesClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorNameAvailabilityWithSubscriptionsClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorsClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.FrontendEndpointsClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.ManagedRuleSetsClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.NetworkExperimentProfilesClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.PoliciesClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.PreconfiguredEndpointsClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.ReportsClientImpl;
import com.azure.resourcemanager.frontdoor.implementation.RulesEnginesClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=FrontDoorManagementClientBuilder.class)
public final class FrontDoorManagementClientImpl
implements FrontDoorManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final PoliciesClient policies;
    private final ManagedRuleSetsClient managedRuleSets;
    private final FrontDoorNameAvailabilitiesClient frontDoorNameAvailabilities;
    private final FrontDoorNameAvailabilityWithSubscriptionsClient frontDoorNameAvailabilityWithSubscriptions;
    private final FrontDoorsClient frontDoors;
    private final FrontendEndpointsClient frontendEndpoints;
    private final EndpointsClient endpoints;
    private final RulesEnginesClient rulesEngines;
    private final NetworkExperimentProfilesClient networkExperimentProfiles;
    private final PreconfiguredEndpointsClient preconfiguredEndpoints;
    private final ExperimentsClient experiments;
    private final ReportsClient reports;
    private static final ClientLogger LOGGER = new ClientLogger(FrontDoorManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public PoliciesClient getPolicies() {
        return this.policies;
    }

    @Override
    public ManagedRuleSetsClient getManagedRuleSets() {
        return this.managedRuleSets;
    }

    @Override
    public FrontDoorNameAvailabilitiesClient getFrontDoorNameAvailabilities() {
        return this.frontDoorNameAvailabilities;
    }

    @Override
    public FrontDoorNameAvailabilityWithSubscriptionsClient getFrontDoorNameAvailabilityWithSubscriptions() {
        return this.frontDoorNameAvailabilityWithSubscriptions;
    }

    @Override
    public FrontDoorsClient getFrontDoors() {
        return this.frontDoors;
    }

    @Override
    public FrontendEndpointsClient getFrontendEndpoints() {
        return this.frontendEndpoints;
    }

    @Override
    public EndpointsClient getEndpoints() {
        return this.endpoints;
    }

    @Override
    public RulesEnginesClient getRulesEngines() {
        return this.rulesEngines;
    }

    @Override
    public NetworkExperimentProfilesClient getNetworkExperimentProfiles() {
        return this.networkExperimentProfiles;
    }

    @Override
    public PreconfiguredEndpointsClient getPreconfiguredEndpoints() {
        return this.preconfiguredEndpoints;
    }

    @Override
    public ExperimentsClient getExperiments() {
        return this.experiments;
    }

    @Override
    public ReportsClient getReports() {
        return this.reports;
    }

    FrontDoorManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.policies = new PoliciesClientImpl(this);
        this.managedRuleSets = new ManagedRuleSetsClientImpl(this);
        this.frontDoorNameAvailabilities = new FrontDoorNameAvailabilitiesClientImpl(this);
        this.frontDoorNameAvailabilityWithSubscriptions = new FrontDoorNameAvailabilityWithSubscriptionsClientImpl(this);
        this.frontDoors = new FrontDoorsClientImpl(this);
        this.frontendEndpoints = new FrontendEndpointsClientImpl(this);
        this.endpoints = new EndpointsClientImpl(this);
        this.rulesEngines = new RulesEnginesClientImpl(this);
        this.networkExperimentProfiles = new NetworkExperimentProfilesClientImpl(this);
        this.preconfiguredEndpoints = new PreconfiguredEndpointsClientImpl(this);
        this.experiments = new ExperimentsClientImpl(this);
        this.reports = new ReportsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

