/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.frontdoor.fluent.FrontDoorNameAvailabilityWithSubscriptionsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.CheckNameAvailabilityOutputInner;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorManagementClientImpl;
import com.azure.resourcemanager.frontdoor.models.CheckNameAvailabilityInput;
import reactor.core.publisher.Mono;

public final class FrontDoorNameAvailabilityWithSubscriptionsClientImpl
implements FrontDoorNameAvailabilityWithSubscriptionsClient {
    private final FrontDoorNameAvailabilityWithSubscriptionsService service;
    private final FrontDoorManagementClientImpl client;

    FrontDoorNameAvailabilityWithSubscriptionsClientImpl(FrontDoorManagementClientImpl client) {
        this.service = (FrontDoorNameAvailabilityWithSubscriptionsService)RestProxy.create(FrontDoorNameAvailabilityWithSubscriptionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityOutputInner>> checkWithResponseAsync(CheckNameAvailabilityInput checkFrontDoorNameAvailabilityInput) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (checkFrontDoorNameAvailabilityInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkFrontDoorNameAvailabilityInput is required and cannot be null."));
        }
        checkFrontDoorNameAvailabilityInput.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.check(this.client.getEndpoint(), this.client.getSubscriptionId(), "2021-06-01", checkFrontDoorNameAvailabilityInput, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameAvailabilityOutputInner>> checkWithResponseAsync(CheckNameAvailabilityInput checkFrontDoorNameAvailabilityInput, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (checkFrontDoorNameAvailabilityInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkFrontDoorNameAvailabilityInput is required and cannot be null."));
        }
        checkFrontDoorNameAvailabilityInput.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.check(this.client.getEndpoint(), this.client.getSubscriptionId(), "2021-06-01", checkFrontDoorNameAvailabilityInput, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CheckNameAvailabilityOutputInner> checkAsync(CheckNameAvailabilityInput checkFrontDoorNameAvailabilityInput) {
        return this.checkWithResponseAsync(checkFrontDoorNameAvailabilityInput).flatMap(res -> Mono.justOrEmpty((Object)((CheckNameAvailabilityOutputInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckNameAvailabilityOutputInner> checkWithResponse(CheckNameAvailabilityInput checkFrontDoorNameAvailabilityInput, Context context) {
        return (Response)this.checkWithResponseAsync(checkFrontDoorNameAvailabilityInput, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckNameAvailabilityOutputInner check(CheckNameAvailabilityInput checkFrontDoorNameAvailabilityInput) {
        return (CheckNameAvailabilityOutputInner)this.checkWithResponse(checkFrontDoorNameAvailabilityInput, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FrontDoorManagementC")
    public static interface FrontDoorNameAvailabilityWithSubscriptionsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/checkFrontDoorNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameAvailabilityOutputInner>> check(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CheckNameAvailabilityInput var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

