/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.FrontDoorsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontDoorInner;
import com.azure.resourcemanager.frontdoor.fluent.models.ValidateCustomDomainOutputInner;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorImpl;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.implementation.ValidateCustomDomainOutputImpl;
import com.azure.resourcemanager.frontdoor.models.FrontDoor;
import com.azure.resourcemanager.frontdoor.models.FrontDoors;
import com.azure.resourcemanager.frontdoor.models.ValidateCustomDomainInput;
import com.azure.resourcemanager.frontdoor.models.ValidateCustomDomainOutput;

public final class FrontDoorsImpl
implements FrontDoors {
    private static final ClientLogger LOGGER = new ClientLogger(FrontDoorsImpl.class);
    private final FrontDoorsClient innerClient;
    private final FrontDoorManager serviceManager;

    public FrontDoorsImpl(FrontDoorsClient innerClient, FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<FrontDoor> list() {
        PagedIterable<FrontDoorInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new FrontDoorImpl((FrontDoorInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<FrontDoor> list(Context context) {
        PagedIterable<FrontDoorInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new FrontDoorImpl((FrontDoorInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<FrontDoor> listByResourceGroup(String resourceGroupName) {
        PagedIterable<FrontDoorInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return Utils.mapPage(inner, inner1 -> new FrontDoorImpl((FrontDoorInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<FrontDoor> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<FrontDoorInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return Utils.mapPage(inner, inner1 -> new FrontDoorImpl((FrontDoorInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<FrontDoor> getByResourceGroupWithResponse(String resourceGroupName, String frontDoorName, Context context) {
        Response<FrontDoorInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, frontDoorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FrontDoorImpl((FrontDoorInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public FrontDoor getByResourceGroup(String resourceGroupName, String frontDoorName) {
        FrontDoorInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, frontDoorName);
        if (inner != null) {
            return new FrontDoorImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String frontDoorName) {
        this.serviceClient().delete(resourceGroupName, frontDoorName);
    }

    @Override
    public void delete(String resourceGroupName, String frontDoorName, Context context) {
        this.serviceClient().delete(resourceGroupName, frontDoorName, context);
    }

    @Override
    public Response<ValidateCustomDomainOutput> validateCustomDomainWithResponse(String resourceGroupName, String frontDoorName, ValidateCustomDomainInput customDomainProperties, Context context) {
        Response<ValidateCustomDomainOutputInner> inner = this.serviceClient().validateCustomDomainWithResponse(resourceGroupName, frontDoorName, customDomainProperties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ValidateCustomDomainOutputImpl((ValidateCustomDomainOutputInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ValidateCustomDomainOutput validateCustomDomain(String resourceGroupName, String frontDoorName, ValidateCustomDomainInput customDomainProperties) {
        ValidateCustomDomainOutputInner inner = this.serviceClient().validateCustomDomain(resourceGroupName, frontDoorName, customDomainProperties);
        if (inner != null) {
            return new ValidateCustomDomainOutputImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public FrontDoor getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        return (FrontDoor)this.getByResourceGroupWithResponse(resourceGroupName, frontDoorName, Context.NONE).getValue();
    }

    @Override
    public Response<FrontDoor> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, frontDoorName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        this.delete(resourceGroupName, frontDoorName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String frontDoorName = Utils.getValueFromIdByName(id, "frontDoors");
        if (frontDoorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'frontDoors'.", id)));
        }
        this.delete(resourceGroupName, frontDoorName, context);
    }

    private FrontDoorsClient serviceClient() {
        return this.innerClient;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }

    @Override
    public FrontDoorImpl define(String name) {
        return new FrontDoorImpl(name, this.manager());
    }
}

