/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.frontdoor.fluent.FrontendEndpointsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontendEndpointInner;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorManagementClientImpl;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsConfiguration;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpointsListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FrontendEndpointsClientImpl
implements FrontendEndpointsClient {
    private final FrontendEndpointsService service;
    private final FrontDoorManagementClientImpl client;

    FrontendEndpointsClientImpl(FrontDoorManagementClientImpl client) {
        this.service = (FrontendEndpointsService)RestProxy.create(FrontendEndpointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FrontendEndpointInner>> listByFrontDoorSinglePageAsync(String resourceGroupName, String frontDoorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFrontDoor(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, "2021-06-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FrontendEndpointsListResult)res.getValue()).value(), ((FrontendEndpointsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FrontendEndpointInner>> listByFrontDoorSinglePageAsync(String resourceGroupName, String frontDoorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByFrontDoor(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, "2021-06-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FrontendEndpointsListResult)res.getValue()).value(), ((FrontendEndpointsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FrontendEndpointInner> listByFrontDoorAsync(String resourceGroupName, String frontDoorName) {
        return new PagedFlux(() -> this.listByFrontDoorSinglePageAsync(resourceGroupName, frontDoorName), nextLink -> this.listByFrontDoorNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FrontendEndpointInner> listByFrontDoorAsync(String resourceGroupName, String frontDoorName, Context context) {
        return new PagedFlux(() -> this.listByFrontDoorSinglePageAsync(resourceGroupName, frontDoorName, context), nextLink -> this.listByFrontDoorNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FrontendEndpointInner> listByFrontDoor(String resourceGroupName, String frontDoorName) {
        return new PagedIterable(this.listByFrontDoorAsync(resourceGroupName, frontDoorName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FrontendEndpointInner> listByFrontDoor(String resourceGroupName, String frontDoorName, Context context) {
        return new PagedIterable(this.listByFrontDoorAsync(resourceGroupName, frontDoorName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FrontendEndpointInner>> getWithResponseAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, frontendEndpointName, "2021-06-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FrontendEndpointInner>> getWithResponseAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, frontendEndpointName, "2021-06-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FrontendEndpointInner> getAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        return this.getWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((FrontendEndpointInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FrontendEndpointInner> getWithResponse(String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FrontendEndpointInner get(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        return (FrontendEndpointInner)((Object)this.getWithResponse(resourceGroupName, frontDoorName, frontendEndpointName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> enableHttpsWithResponseAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        if (customHttpsConfiguration == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customHttpsConfiguration is required and cannot be null."));
        }
        customHttpsConfiguration.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enableHttps(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, frontendEndpointName, "2021-06-01", customHttpsConfiguration, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> enableHttpsWithResponseAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        if (customHttpsConfiguration == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customHttpsConfiguration is required and cannot be null."));
        }
        customHttpsConfiguration.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.enableHttps(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, frontendEndpointName, "2021-06-01", customHttpsConfiguration, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginEnableHttpsAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableHttpsWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginEnableHttpsAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.enableHttpsWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginEnableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration) {
        return this.beginEnableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginEnableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration, Context context) {
        return this.beginEnableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> enableHttpsAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration) {
        return this.beginEnableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> enableHttpsAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration, Context context) {
        return this.beginEnableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration) {
        this.enableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration, Context context) {
        this.enableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> disableHttpsWithResponseAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.disableHttps(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, frontendEndpointName, "2021-06-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> disableHttpsWithResponseAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (frontDoorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontDoorName is required and cannot be null."));
        }
        if (frontendEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter frontendEndpointName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.disableHttps(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, frontDoorName, frontendEndpointName, "2021-06-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDisableHttpsAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.disableHttpsWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDisableHttpsAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.disableHttpsWithResponseAsync(resourceGroupName, frontDoorName, frontendEndpointName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDisableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        return this.beginDisableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDisableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        return this.beginDisableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> disableHttpsAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        return this.beginDisableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> disableHttpsAsync(String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        return this.beginDisableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        this.disableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void disableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        this.disableHttpsAsync(resourceGroupName, frontDoorName, frontendEndpointName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FrontendEndpointInner>> listByFrontDoorNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFrontDoorNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FrontendEndpointsListResult)res.getValue()).value(), ((FrontendEndpointsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FrontendEndpointInner>> listByFrontDoorNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByFrontDoorNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FrontendEndpointsListResult)res.getValue()).value(), ((FrontendEndpointsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FrontDoorManagementC")
    public static interface FrontendEndpointsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FrontendEndpointsListResult>> listByFrontDoor(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="frontDoorName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints/{frontendEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FrontendEndpointInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="frontDoorName") String var4, @PathParam(value="frontendEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints/{frontendEndpointName}/enableHttps")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> enableHttps(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="frontDoorName") String var4, @PathParam(value="frontendEndpointName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") CustomHttpsConfiguration var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints/{frontendEndpointName}/disableHttps")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> disableHttps(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="frontDoorName") String var4, @PathParam(value="frontendEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FrontendEndpointsListResult>> listByFrontDoorNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

