/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.FrontendEndpointsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.FrontendEndpointInner;
import com.azure.resourcemanager.frontdoor.implementation.FrontendEndpointImpl;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.CustomHttpsConfiguration;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpoint;
import com.azure.resourcemanager.frontdoor.models.FrontendEndpoints;

public final class FrontendEndpointsImpl
implements FrontendEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(FrontendEndpointsImpl.class);
    private final FrontendEndpointsClient innerClient;
    private final FrontDoorManager serviceManager;

    public FrontendEndpointsImpl(FrontendEndpointsClient innerClient, FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<FrontendEndpoint> listByFrontDoor(String resourceGroupName, String frontDoorName) {
        PagedIterable<FrontendEndpointInner> inner = this.serviceClient().listByFrontDoor(resourceGroupName, frontDoorName);
        return Utils.mapPage(inner, inner1 -> new FrontendEndpointImpl((FrontendEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<FrontendEndpoint> listByFrontDoor(String resourceGroupName, String frontDoorName, Context context) {
        PagedIterable<FrontendEndpointInner> inner = this.serviceClient().listByFrontDoor(resourceGroupName, frontDoorName, context);
        return Utils.mapPage(inner, inner1 -> new FrontendEndpointImpl((FrontendEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<FrontendEndpoint> getWithResponse(String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        Response<FrontendEndpointInner> inner = this.serviceClient().getWithResponse(resourceGroupName, frontDoorName, frontendEndpointName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new FrontendEndpointImpl((FrontendEndpointInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public FrontendEndpoint get(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        FrontendEndpointInner inner = this.serviceClient().get(resourceGroupName, frontDoorName, frontendEndpointName);
        if (inner != null) {
            return new FrontendEndpointImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void enableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration) {
        this.serviceClient().enableHttps(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration);
    }

    @Override
    public void enableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName, CustomHttpsConfiguration customHttpsConfiguration, Context context) {
        this.serviceClient().enableHttps(resourceGroupName, frontDoorName, frontendEndpointName, customHttpsConfiguration, context);
    }

    @Override
    public void disableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName) {
        this.serviceClient().disableHttps(resourceGroupName, frontDoorName, frontendEndpointName);
    }

    @Override
    public void disableHttps(String resourceGroupName, String frontDoorName, String frontendEndpointName, Context context) {
        this.serviceClient().disableHttps(resourceGroupName, frontDoorName, frontendEndpointName, context);
    }

    private FrontendEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }
}

