/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.ManagedRuleSetsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.ManagedRuleSetDefinitionInner;
import com.azure.resourcemanager.frontdoor.implementation.ManagedRuleSetDefinitionImpl;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleSetDefinition;
import com.azure.resourcemanager.frontdoor.models.ManagedRuleSets;

public final class ManagedRuleSetsImpl
implements ManagedRuleSets {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleSetsImpl.class);
    private final ManagedRuleSetsClient innerClient;
    private final FrontDoorManager serviceManager;

    public ManagedRuleSetsImpl(ManagedRuleSetsClient innerClient, FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ManagedRuleSetDefinition> list() {
        PagedIterable<ManagedRuleSetDefinitionInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new ManagedRuleSetDefinitionImpl((ManagedRuleSetDefinitionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedRuleSetDefinition> list(Context context) {
        PagedIterable<ManagedRuleSetDefinitionInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new ManagedRuleSetDefinitionImpl((ManagedRuleSetDefinitionInner)((Object)inner1), this.manager()));
    }

    private ManagedRuleSetsClient serviceClient() {
        return this.innerClient;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }
}

