/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.frontdoor.fluent.PoliciesClient;
import com.azure.resourcemanager.frontdoor.fluent.models.WebApplicationFirewallPolicyInner;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorManagementClientImpl;
import com.azure.resourcemanager.frontdoor.models.TagsObject;
import com.azure.resourcemanager.frontdoor.models.WebApplicationFirewallPolicyList;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PoliciesClientImpl
implements PoliciesClient {
    private final PoliciesService service;
    private final FrontDoorManagementClientImpl client;

    PoliciesClientImpl(FrontDoorManagementClientImpl client) {
        this.service = (PoliciesService)RestProxy.create(PoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebApplicationFirewallPolicyInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), "2022-05-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebApplicationFirewallPolicyList)res.getValue()).value(), ((WebApplicationFirewallPolicyList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebApplicationFirewallPolicyInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), "2022-05-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebApplicationFirewallPolicyList)res.getValue()).value(), ((WebApplicationFirewallPolicyList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WebApplicationFirewallPolicyInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WebApplicationFirewallPolicyInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebApplicationFirewallPolicyInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebApplicationFirewallPolicyInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebApplicationFirewallPolicyInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2022-05-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebApplicationFirewallPolicyList)res.getValue()).value(), ((WebApplicationFirewallPolicyList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebApplicationFirewallPolicyInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2022-05-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebApplicationFirewallPolicyList)res.getValue()).value(), ((WebApplicationFirewallPolicyList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WebApplicationFirewallPolicyInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WebApplicationFirewallPolicyInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebApplicationFirewallPolicyInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebApplicationFirewallPolicyInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WebApplicationFirewallPolicyInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String policyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, policyName, this.client.getSubscriptionId(), "2022-05-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WebApplicationFirewallPolicyInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String policyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, policyName, this.client.getSubscriptionId(), "2022-05-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WebApplicationFirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String policyName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, policyName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((WebApplicationFirewallPolicyInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WebApplicationFirewallPolicyInner> getByResourceGroupWithResponse(String resourceGroupName, String policyName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, policyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WebApplicationFirewallPolicyInner getByResourceGroup(String resourceGroupName, String policyName) {
        return (WebApplicationFirewallPolicyInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, policyName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, policyName, this.client.getSubscriptionId(), "2022-05-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, policyName, this.client.getSubscriptionId(), "2022-05-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, policyName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WebApplicationFirewallPolicyInner.class), (Type)((Object)WebApplicationFirewallPolicyInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, policyName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WebApplicationFirewallPolicyInner.class), (Type)((Object)WebApplicationFirewallPolicyInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner> beginCreateOrUpdate(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, policyName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner> beginCreateOrUpdate(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, policyName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, policyName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WebApplicationFirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, policyName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WebApplicationFirewallPolicyInner createOrUpdate(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters) {
        return (WebApplicationFirewallPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, policyName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WebApplicationFirewallPolicyInner createOrUpdate(String resourceGroupName, String policyName, WebApplicationFirewallPolicyInner parameters, Context context) {
        return (WebApplicationFirewallPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, policyName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String policyName, TagsObject parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, policyName, this.client.getSubscriptionId(), "2022-05-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String policyName, TagsObject parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, policyName, this.client.getSubscriptionId(), "2022-05-01", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName, TagsObject parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, policyName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WebApplicationFirewallPolicyInner.class), (Type)((Object)WebApplicationFirewallPolicyInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner> beginUpdateAsync(String resourceGroupName, String policyName, TagsObject parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, policyName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)WebApplicationFirewallPolicyInner.class), (Type)((Object)WebApplicationFirewallPolicyInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner> beginUpdate(String resourceGroupName, String policyName, TagsObject parameters) {
        return this.beginUpdateAsync(resourceGroupName, policyName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<WebApplicationFirewallPolicyInner>, WebApplicationFirewallPolicyInner> beginUpdate(String resourceGroupName, String policyName, TagsObject parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, policyName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName, TagsObject parameters) {
        return this.beginUpdateAsync(resourceGroupName, policyName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<WebApplicationFirewallPolicyInner> updateAsync(String resourceGroupName, String policyName, TagsObject parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, policyName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WebApplicationFirewallPolicyInner update(String resourceGroupName, String policyName, TagsObject parameters) {
        return (WebApplicationFirewallPolicyInner)((Object)this.updateAsync(resourceGroupName, policyName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WebApplicationFirewallPolicyInner update(String resourceGroupName, String policyName, TagsObject parameters, Context context) {
        return (WebApplicationFirewallPolicyInner)((Object)this.updateAsync(resourceGroupName, policyName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String policyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, policyName, this.client.getSubscriptionId(), "2022-05-01", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String policyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-05-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, policyName, this.client.getSubscriptionId(), "2022-05-01", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String policyName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, policyName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String policyName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, policyName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String policyName) {
        return this.beginDeleteAsync(resourceGroupName, policyName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String policyName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, policyName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String policyName) {
        return this.beginDeleteAsync(resourceGroupName, policyName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String policyName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, policyName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String policyName) {
        this.deleteAsync(resourceGroupName, policyName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String policyName, Context context) {
        this.deleteAsync(resourceGroupName, policyName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebApplicationFirewallPolicyInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebApplicationFirewallPolicyList)res.getValue()).value(), ((WebApplicationFirewallPolicyList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebApplicationFirewallPolicyInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebApplicationFirewallPolicyList)res.getValue()).value(), ((WebApplicationFirewallPolicyList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebApplicationFirewallPolicyInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebApplicationFirewallPolicyList)res.getValue()).value(), ((WebApplicationFirewallPolicyList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebApplicationFirewallPolicyInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebApplicationFirewallPolicyList)res.getValue()).value(), ((WebApplicationFirewallPolicyList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FrontDoorManagementC")
    public static interface PoliciesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WebApplicationFirewallPolicyList>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WebApplicationFirewallPolicyList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/FrontDoorWebApplicationFirewallPolicies/{policyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WebApplicationFirewallPolicyInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="policyName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/FrontDoorWebApplicationFirewallPolicies/{policyName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="policyName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") WebApplicationFirewallPolicyInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/FrontDoorWebApplicationFirewallPolicies/{policyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="policyName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") TagsObject var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/FrontDoorWebApplicationFirewallPolicies/{policyName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="policyName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WebApplicationFirewallPolicyList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WebApplicationFirewallPolicyList>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

