/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.PreconfiguredEndpointsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.PreconfiguredEndpointInner;
import com.azure.resourcemanager.frontdoor.implementation.PreconfiguredEndpointImpl;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.PreconfiguredEndpoint;
import com.azure.resourcemanager.frontdoor.models.PreconfiguredEndpoints;

public final class PreconfiguredEndpointsImpl
implements PreconfiguredEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(PreconfiguredEndpointsImpl.class);
    private final PreconfiguredEndpointsClient innerClient;
    private final FrontDoorManager serviceManager;

    public PreconfiguredEndpointsImpl(PreconfiguredEndpointsClient innerClient, FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PreconfiguredEndpoint> list(String resourceGroupName, String profileName) {
        PagedIterable<PreconfiguredEndpointInner> inner = this.serviceClient().list(resourceGroupName, profileName);
        return Utils.mapPage(inner, inner1 -> new PreconfiguredEndpointImpl((PreconfiguredEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PreconfiguredEndpoint> list(String resourceGroupName, String profileName, Context context) {
        PagedIterable<PreconfiguredEndpointInner> inner = this.serviceClient().list(resourceGroupName, profileName, context);
        return Utils.mapPage(inner, inner1 -> new PreconfiguredEndpointImpl((PreconfiguredEndpointInner)((Object)inner1), this.manager()));
    }

    private PreconfiguredEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }
}

