/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.models.ProfileInner;
import com.azure.resourcemanager.frontdoor.implementation.Utils;
import com.azure.resourcemanager.frontdoor.models.NetworkExperimentResourceState;
import com.azure.resourcemanager.frontdoor.models.Profile;
import com.azure.resourcemanager.frontdoor.models.ProfileUpdateModel;
import com.azure.resourcemanager.frontdoor.models.State;
import java.util.Collections;
import java.util.Map;

public final class ProfileImpl
implements Profile,
Profile.Definition,
Profile.Update {
    private ProfileInner innerObject;
    private final FrontDoorManager serviceManager;
    private String profileName;
    private String resourceGroupName;
    private ProfileUpdateModel updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public NetworkExperimentResourceState resourceState() {
        return this.innerModel().resourceState();
    }

    @Override
    public State enabledState() {
        return this.innerModel().enabledState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ProfileInner innerModel() {
        return this.innerObject;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProfileImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Profile create() {
        this.innerObject = this.serviceManager.serviceClient().getNetworkExperimentProfiles().createOrUpdate(this.profileName, this.resourceGroupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Profile create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNetworkExperimentProfiles().createOrUpdate(this.profileName, this.resourceGroupName, this.innerModel(), context);
        return this;
    }

    ProfileImpl(String name, FrontDoorManager serviceManager) {
        this.innerObject = new ProfileInner();
        this.serviceManager = serviceManager;
        this.profileName = name;
    }

    @Override
    public ProfileImpl update() {
        this.updateParameters = new ProfileUpdateModel();
        return this;
    }

    @Override
    public Profile apply() {
        this.innerObject = this.serviceManager.serviceClient().getNetworkExperimentProfiles().update(this.resourceGroupName, this.profileName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Profile apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getNetworkExperimentProfiles().update(this.resourceGroupName, this.profileName, this.updateParameters, context);
        return this;
    }

    ProfileImpl(ProfileInner innerObject, FrontDoorManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.profileName = Utils.getValueFromIdByName(innerObject.id(), "NetworkExperimentProfiles");
    }

    @Override
    public Profile refresh() {
        this.innerObject = (ProfileInner)((Object)this.serviceManager.serviceClient().getNetworkExperimentProfiles().getByResourceGroupWithResponse(this.resourceGroupName, this.profileName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Profile refresh(Context context) {
        this.innerObject = (ProfileInner)((Object)this.serviceManager.serviceClient().getNetworkExperimentProfiles().getByResourceGroupWithResponse(this.resourceGroupName, this.profileName, context).getValue());
        return this;
    }

    @Override
    public ProfileImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ProfileImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ProfileImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ProfileImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public ProfileImpl withEnabledState(State enabledState) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnabledState(enabledState);
            return this;
        }
        this.updateParameters.withEnabledState(enabledState);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

