/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.frontdoor.fluent.ReportsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.LatencyScorecardInner;
import com.azure.resourcemanager.frontdoor.fluent.models.TimeseriesInner;
import com.azure.resourcemanager.frontdoor.implementation.FrontDoorManagementClientImpl;
import com.azure.resourcemanager.frontdoor.models.LatencyScorecardAggregationInterval;
import com.azure.resourcemanager.frontdoor.models.TimeseriesAggregationInterval;
import com.azure.resourcemanager.frontdoor.models.TimeseriesType;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class ReportsClientImpl
implements ReportsClient {
    private final ReportsService service;
    private final FrontDoorManagementClientImpl client;

    ReportsClientImpl(FrontDoorManagementClientImpl client) {
        this.service = (ReportsService)RestProxy.create(ReportsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LatencyScorecardInner>> getLatencyScorecardsWithResponseAsync(String resourceGroupName, String profileName, String experimentName, LatencyScorecardAggregationInterval aggregationInterval, String endDateTimeUtc, String country) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        if (aggregationInterval == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aggregationInterval is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getLatencyScorecards(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, endDateTimeUtc, country, aggregationInterval, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LatencyScorecardInner>> getLatencyScorecardsWithResponseAsync(String resourceGroupName, String profileName, String experimentName, LatencyScorecardAggregationInterval aggregationInterval, String endDateTimeUtc, String country, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        if (aggregationInterval == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aggregationInterval is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getLatencyScorecards(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, endDateTimeUtc, country, aggregationInterval, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LatencyScorecardInner> getLatencyScorecardsAsync(String resourceGroupName, String profileName, String experimentName, LatencyScorecardAggregationInterval aggregationInterval) {
        String endDateTimeUtc = null;
        String country = null;
        return this.getLatencyScorecardsWithResponseAsync(resourceGroupName, profileName, experimentName, aggregationInterval, endDateTimeUtc, country).flatMap(res -> Mono.justOrEmpty((Object)((Object)((LatencyScorecardInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LatencyScorecardInner> getLatencyScorecardsWithResponse(String resourceGroupName, String profileName, String experimentName, LatencyScorecardAggregationInterval aggregationInterval, String endDateTimeUtc, String country, Context context) {
        return (Response)this.getLatencyScorecardsWithResponseAsync(resourceGroupName, profileName, experimentName, aggregationInterval, endDateTimeUtc, country, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LatencyScorecardInner getLatencyScorecards(String resourceGroupName, String profileName, String experimentName, LatencyScorecardAggregationInterval aggregationInterval) {
        String endDateTimeUtc = null;
        String country = null;
        return (LatencyScorecardInner)((Object)this.getLatencyScorecardsWithResponse(resourceGroupName, profileName, experimentName, aggregationInterval, endDateTimeUtc, country, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TimeseriesInner>> getTimeseriesWithResponseAsync(String resourceGroupName, String profileName, String experimentName, OffsetDateTime startDateTimeUtc, OffsetDateTime endDateTimeUtc, TimeseriesAggregationInterval aggregationInterval, TimeseriesType timeseriesType, String endpointParam, String country) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        if (startDateTimeUtc == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter startDateTimeUtc is required and cannot be null."));
        }
        if (endDateTimeUtc == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endDateTimeUtc is required and cannot be null."));
        }
        if (aggregationInterval == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aggregationInterval is required and cannot be null."));
        }
        if (timeseriesType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter timeseriesType is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTimeseries(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, startDateTimeUtc, endDateTimeUtc, aggregationInterval, timeseriesType, endpointParam, country, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TimeseriesInner>> getTimeseriesWithResponseAsync(String resourceGroupName, String profileName, String experimentName, OffsetDateTime startDateTimeUtc, OffsetDateTime endDateTimeUtc, TimeseriesAggregationInterval aggregationInterval, TimeseriesType timeseriesType, String endpointParam, String country, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (experimentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter experimentName is required and cannot be null."));
        }
        if (startDateTimeUtc == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter startDateTimeUtc is required and cannot be null."));
        }
        if (endDateTimeUtc == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endDateTimeUtc is required and cannot be null."));
        }
        if (aggregationInterval == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter aggregationInterval is required and cannot be null."));
        }
        if (timeseriesType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter timeseriesType is required and cannot be null."));
        }
        String apiVersion = "2019-11-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getTimeseries(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-11-01", resourceGroupName, profileName, experimentName, startDateTimeUtc, endDateTimeUtc, aggregationInterval, timeseriesType, endpointParam, country, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TimeseriesInner> getTimeseriesAsync(String resourceGroupName, String profileName, String experimentName, OffsetDateTime startDateTimeUtc, OffsetDateTime endDateTimeUtc, TimeseriesAggregationInterval aggregationInterval, TimeseriesType timeseriesType) {
        String endpointParam = null;
        String country = null;
        return this.getTimeseriesWithResponseAsync(resourceGroupName, profileName, experimentName, startDateTimeUtc, endDateTimeUtc, aggregationInterval, timeseriesType, endpointParam, country).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TimeseriesInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TimeseriesInner> getTimeseriesWithResponse(String resourceGroupName, String profileName, String experimentName, OffsetDateTime startDateTimeUtc, OffsetDateTime endDateTimeUtc, TimeseriesAggregationInterval aggregationInterval, TimeseriesType timeseriesType, String endpointParam, String country, Context context) {
        return (Response)this.getTimeseriesWithResponseAsync(resourceGroupName, profileName, experimentName, startDateTimeUtc, endDateTimeUtc, aggregationInterval, timeseriesType, endpointParam, country, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TimeseriesInner getTimeseries(String resourceGroupName, String profileName, String experimentName, OffsetDateTime startDateTimeUtc, OffsetDateTime endDateTimeUtc, TimeseriesAggregationInterval aggregationInterval, TimeseriesType timeseriesType) {
        String endpointParam = null;
        String country = null;
        return (TimeseriesInner)((Object)this.getTimeseriesWithResponse(resourceGroupName, profileName, experimentName, startDateTimeUtc, endDateTimeUtc, aggregationInterval, timeseriesType, endpointParam, country, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FrontDoorManagementC")
    public static interface ReportsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}/LatencyScorecard")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LatencyScorecardInner>> getLatencyScorecards(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="experimentName") String var6, @QueryParam(value="endDateTimeUTC") String var7, @QueryParam(value="country") String var8, @QueryParam(value="aggregationInterval") LatencyScorecardAggregationInterval var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}/Timeseries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TimeseriesInner>> getTimeseries(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="profileName") String var5, @PathParam(value="experimentName") String var6, @QueryParam(value="startDateTimeUTC") OffsetDateTime var7, @QueryParam(value="endDateTimeUTC") OffsetDateTime var8, @QueryParam(value="aggregationInterval") TimeseriesAggregationInterval var9, @QueryParam(value="timeseriesType") TimeseriesType var10, @QueryParam(value="endpoint") String var11, @QueryParam(value="country") String var12, @HeaderParam(value="Accept") String var13, Context var14);
    }
}

