/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.frontdoor.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.frontdoor.FrontDoorManager;
import com.azure.resourcemanager.frontdoor.fluent.ReportsClient;
import com.azure.resourcemanager.frontdoor.fluent.models.LatencyScorecardInner;
import com.azure.resourcemanager.frontdoor.fluent.models.TimeseriesInner;
import com.azure.resourcemanager.frontdoor.implementation.LatencyScorecardImpl;
import com.azure.resourcemanager.frontdoor.implementation.TimeseriesImpl;
import com.azure.resourcemanager.frontdoor.models.LatencyScorecard;
import com.azure.resourcemanager.frontdoor.models.LatencyScorecardAggregationInterval;
import com.azure.resourcemanager.frontdoor.models.Reports;
import com.azure.resourcemanager.frontdoor.models.Timeseries;
import com.azure.resourcemanager.frontdoor.models.TimeseriesAggregationInterval;
import com.azure.resourcemanager.frontdoor.models.TimeseriesType;
import java.time.OffsetDateTime;

public final class ReportsImpl
implements Reports {
    private static final ClientLogger LOGGER = new ClientLogger(ReportsImpl.class);
    private final ReportsClient innerClient;
    private final FrontDoorManager serviceManager;

    public ReportsImpl(ReportsClient innerClient, FrontDoorManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<LatencyScorecard> getLatencyScorecardsWithResponse(String resourceGroupName, String profileName, String experimentName, LatencyScorecardAggregationInterval aggregationInterval, String endDateTimeUtc, String country, Context context) {
        Response<LatencyScorecardInner> inner = this.serviceClient().getLatencyScorecardsWithResponse(resourceGroupName, profileName, experimentName, aggregationInterval, endDateTimeUtc, country, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LatencyScorecardImpl((LatencyScorecardInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public LatencyScorecard getLatencyScorecards(String resourceGroupName, String profileName, String experimentName, LatencyScorecardAggregationInterval aggregationInterval) {
        LatencyScorecardInner inner = this.serviceClient().getLatencyScorecards(resourceGroupName, profileName, experimentName, aggregationInterval);
        if (inner != null) {
            return new LatencyScorecardImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Timeseries> getTimeseriesWithResponse(String resourceGroupName, String profileName, String experimentName, OffsetDateTime startDateTimeUtc, OffsetDateTime endDateTimeUtc, TimeseriesAggregationInterval aggregationInterval, TimeseriesType timeseriesType, String endpointParam, String country, Context context) {
        Response<TimeseriesInner> inner = this.serviceClient().getTimeseriesWithResponse(resourceGroupName, profileName, experimentName, startDateTimeUtc, endDateTimeUtc, aggregationInterval, timeseriesType, endpointParam, country, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TimeseriesImpl((TimeseriesInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Timeseries getTimeseries(String resourceGroupName, String profileName, String experimentName, OffsetDateTime startDateTimeUtc, OffsetDateTime endDateTimeUtc, TimeseriesAggregationInterval aggregationInterval, TimeseriesType timeseriesType) {
        TimeseriesInner inner = this.serviceClient().getTimeseries(resourceGroupName, profileName, experimentName, startDateTimeUtc, endDateTimeUtc, aggregationInterval, timeseriesType);
        if (inner != null) {
            return new TimeseriesImpl(inner, this.manager());
        }
        return null;
    }

    private ReportsClient serviceClient() {
        return this.innerClient;
    }

    private FrontDoorManager manager() {
        return this.serviceManager;
    }
}

